% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/small2other.R
\name{small2other}
\alias{small2other}
\title{Recoding the smallest categories to "other" value in case of too many or too small categories.}
\usage{
small2other(
  x,
  maxLevels = 12,
  minFreq = 0,
  otherValue = "other",
  convertNA = TRUE,
  orderLevels = FALSE,
  otherLast = FALSE
)
}
\arguments{
\item{x}{The variable to be recoded.}

\item{maxLevels}{The maximum number of levels after recoding}

\item{minFreq}{The minimal frequency after recoding.}

\item{otherValue}{The name give to the new category}

\item{convertNA}{Should the \code{NA} values be converted to ordinary values. If \code{TRUE}, they are converted to string \code{"NA"}. If \code{FALSE}, there are left as missing and ignored in the recording.}

\item{orderLevels}{How should the categories be ordered. Possible values are:
\itemize{
\item \code{FALSE} - do not change the ordering (default)
\item \code{alpha} - alphabetically; and
\item {freq} - based on frequencies (highest frequencies first).
}}

\item{otherLast}{Only used if category with \code{otherValue} was created. If \code{TRUE}, the \code{otherValue} is placed as last category regardless of the \code{orderLevels} argument. Defaults to \code{FALSE}.}
}
\description{
The smallest categories are recoded to "other" or user specified string. The variables is converted to factor if not  already.
}
