% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapLda.R
\name{mapLda}
\alias{mapLda}
\title{LDA mapping}
\usage{
mapLda(
  object,
  xlim = c(-2, 2),
  ylim = c(-2, 2),
  npoints = 101,
  prior = object$prior,
  dimen = 2,
  col = NULL
)
}
\arguments{
\item{object}{Object obtained by \code{ldaPlus} function or \code{MASS::lda} function.}

\item{xlim}{Limits of the \eqn{x}-axis.}

\item{ylim}{Limits of the \eqn{y}-axis.}

\item{npoints}{Number of points on y-axis and x-axis (i.e., drawing precision).}

\item{prior}{Prior probabilities of class membership to estimate the model (they can be estimated based on the sample data or they can be provided by a reseacher).}

\item{dimen}{Number of dimensions used for prediction. Probably only 2 (as these are used for drawing) makes sense.}

\item{col}{Vector of mapping colors, default is \code{NULL} (i.e., it takes the default R colors).}
}
\value{
No return value, called for side effects (plotting a map).
}
\description{
The function draws two dimensional map of discriminant functions.
}
\examples{
# Estimate the LDA model:
ldaCars <- ldaPlus(x = mtcars[,c(1, 3, 4, 5, 6)], grouping = mtcars[,10])
# Plot LDA map:
mapLda(ldaCars)
}
\author{
Aleš Žiberna
}
