% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cancorPlus.R
\name{cancorPlus}
\alias{cancorPlus}
\title{Canonical correlations}
\usage{
cancorPlus(x, y, xcenter = TRUE, ycenter = TRUE, useCCApackage = FALSE)
}
\arguments{
\item{x}{A data frame or a matrix with the values that correspond to the first set of variables (\eqn{X}-variables).}

\item{y}{A data frame or a matrix with the values that correspond to the second set of variables (\eqn{Y}-variables).}

\item{xcenter}{Whether any centring have to be done on the \eqn{x} values before the analysis. If \code{TRUE} (default), subtract the column means. If \code{FALSE}, do not adjust the columns. Otherwise, a vector of values to be subtracted from the columns.}

\item{ycenter}{Analogous to \code{xcenter}, but for the \eqn{y} values.}

\item{useCCApackage}{Whether \code{cc} function (from \code{CCA} package) or \code{cancor} function (from \code{stats} package) should be used to obtain canonical correlations.}
}
\value{
The function returns the same output as functions \code{cancor} or \code{cc} with the following additional elements:
\itemize{
\item \code{$sigTest}
\itemize{
\item \code{WilksL} - Value of the Wilk's lambda statistic (it is a generalization of the multivariate R2; values near 0 indicate high correlation while values near 1 indicate low correlation).
\item \code{F} - Corresponding (to Wilk's lambda) F-ratio.
\item \code{df1} - Degrees of freedom for the corresponding F-ratio.
\item \code{df2} - Degrees of freedom for the corresponding F-ratio.
\item \code{p} - Probability value (p-value) for the corresponding F-ratio (Ho: The current and all the later canonical correlations equal to zero).
}
\item \code{$eigModel}
\itemize{
\item \code{Eigenvalues} - Eigenvalues of the canonical roots.
\item \code{\%} - Proportion of explained variance of correlation.
\item \code{Cum \%} - Cumulative proportion of explained variance of correlation.
\item \code{Cor} - Canonical correlation coefficient.
\item \code{Sq. Cor} - Squared canonical correlation coefficient.
}
}
}
\description{
The function computes canonical correlations (by using \code{cc} or \code{cancor} functions) and provides with the test of
canonical correlations and with the eigenvalues of the canonical roots (including with the proportion of explained variances by correlation and other related
statistics).
}
\examples{
cancorPlus(x = mtcars[, c(1,2,3)], y = mtcars[, c(4,5, 6)])
}
\references{
R Data Analysis Examples: Canonical Correlation Analysis, UCLA: Statistical Consulting Group. From http://www.ats.ucla.edu/stat/r/dae/canonical.htm (accessed Decembar 27, 2013).
}
\seealso{
\code{testCC}
}
\author{
Adapted by Aleš Žiberna based on the source in References.
}
