% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_2_ABC.R
\name{estimate_2_ABC}
\alias{estimate_2_ABC}
\title{Estimation Method: Approximate Bayesian Computation (ABC)}
\usage{
estimate_2_ABC(
  data,
  colnames,
  behrule,
  ids = NULL,
  models,
  funcs = NULL,
  priors,
  settings = NULL,
  lowers,
  uppers,
  control,
  ...
)
}
\arguments{
\item{data}{A data frame in which each row represents a single trial,
see \link[multiRL]{data}}

\item{colnames}{Column names in the data frame,
see \link[multiRL]{colnames}}

\item{behrule}{The agent’s implicitly formed internal rule,
see \link[multiRL]{behrule}}

\item{ids}{The Subject ID of the participant whose data needs to be fitted.}

\item{models}{Reinforcement Learning Models}

\item{funcs}{The functions forming the reinforcement learning model,
see \link[multiRL]{funcs}}

\item{priors}{Prior probability density function of the free parameters,
see \link[multiRL]{priors}}

\item{settings}{Other model settings, 
see \link[multiRL]{settings}}

\item{lowers}{Lower bound of free parameters in each model.}

\item{uppers}{Upper bound of free parameters in each model.}

\item{control}{Settings manage various aspects of the iterative process,
see \link[multiRL]{control}}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
An S3 object of class \code{DataFrame} containing, for each model, 
 the estimated optimal parameters and associated model fit metrics.
}
\description{
This function takes a large set of simulated data to train an Approximate 
   Bayesian Computation (ABC) model and then uses the trained model to 
   estimate optimal parameters for the target data.
}
