% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiCA.R
\name{power.multiCA.test}
\alias{power.multiCA.test}
\title{Power calculations for the multinomial Cochran-Armitage trend test}
\usage{
power.multiCA.test(
  N = NULL,
  power = NULL,
  pmatrix = NULL,
  p.ave = NULL,
  p.start = NULL,
  p.end = NULL,
  slopes = NULL,
  scores = 1:G,
  n.prop = rep(1, G),
  G = length(p.ave),
  sig.level = 0.05
)
}
\arguments{
\item{N}{integer, the total sample size of the study. If \code{NULL} then \code{power} needs to be specified.}

\item{power}{target power. If \code{NULL} then \code{N} needs to be specified.}

\item{pmatrix}{numeric matrix of hypothesized outcome probabilities in each group,  with 
the outcomes as rows and ordered groups as columns. The columns should add up to 1.}

\item{p.ave}{numeric vector of average probability of each outcome over the groups
weighted by \code{n.prop}.}

\item{p.start, p.end}{numeric vectors of the probability of each outcome for the
first / last ordered group}

\item{slopes}{numeric vector of the hypothesized slope of each outcome when regressed
against the column \code{scores} with weights \code{n.prop}. The values should add up to zero,
as the total probability is always 1 and has no trend.}

\item{scores}{non-decreasing numeric vector of the same length as the number of ordered groups
giving the trend test scores. Defaults to linearly increasing values.}

\item{n.prop}{numeric vector describing relative sample sizes of the ordered groups.
Will be normalized to sum to 1. Defaults to equal sample sizes.}

\item{G}{integer, number of ordered groups}

\item{sig.level}{significance level}
}
\value{
object of class "power.htest"
}
\description{
Given the probabilities of outcomes, compute the power of the overall multinomial 
Cochran-Armitage trend test or determine the sample size to obtain a target power.
}
\details{
The sample size calculation depends only on \code{p.ave} - the weighted average probability of 
each outcome, and \code{slopes} - the weighted regression slope of each outcome.

The values of these two key inputs can be specified in three ways: 

1. directly passing \code{p.ave} and  \code{slopes}, or 

2. specifying exactly two of the parameters \code{p.ave}, \code{slopes}, \code{p.start}, and \code{p.end}. 
In this case the full matrix of outcome probabilities will be inferred
assuming linearity within each outcome.

3. specifying the full matrix of outcome probabilities \code{pmatrix}.  

The calculation is based on approximating the distribution of the test statistic
under the alternative with a non-central chi-squared distribution instead of the correct
weighted mixture of multiple non-central chi-squares. This results in bias in the power
away from 50% - values above it are somewhat overestimated, while values under it are
underestimated.
}
\examples{
power.multiCA.test(power=0.8, p.start=c(0.1,0.2,0.3,0.4), p.end=c(0.4, 0.3, 0.2, 0.1), 
                     G=5, n.prop=c(3,2,1,2,3))

## Power of stroke study with 100 subjects per year and observed trends
data(stroke)
strk.mat <- xtabs(Freq ~ Type + Year, data=stroke)
power.multiCA.test(N=900, pmatrix=prop.table(strk.mat, margin=2))
}
\references{
Szabo, A. (2018). Test for Trend With a Multinomial Outcome. The American Statistician, 73(4), 313–320.
}
\seealso{
\code{\link{power.CA.test}} for simpler (and more precise) power calculation 
with a binomial outcome
}
