% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/documentation.R, R/inputs.R
\name{Tabs}
\alias{Tabs}
\alias{Tabs.shinyInput}
\alias{updateTabs.shinyInput}
\title{Tabs}
\usage{
Tabs(...)

Tabs.shinyInput(inputId, ..., value = defaultValue)

updateTabs.shinyInput(
  session = shiny::getDefaultReactiveDomain(),
  inputId,
  ...
)
}
\arguments{
\item{...}{Props to pass to the component.}

\item{inputId}{ID of the component.}

\item{value}{Starting value.}

\item{session}{Object passed as the `session` argument to Shiny server.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
}
\description{
\url{https://mui.com/material-ui/api/tabs/}
}
\details{
\itemize{
\item action \code{ref} \cr Default is - Callback fired when the component mounts. This is useful when you want to trigger an action programmatically. It supports two actions: updateIndicator() and updateScrollButtons()
\item allowScrollButtonsMobile \code{bool} \cr Default is FALSE If true, the scroll buttons aren't forced hidden on mobile. By default the scroll buttons are hidden on mobile and takes precedence over scrollButtons.
\item aria-label \code{string} \cr Default is - The label for the Tabs as a string.
\item aria-labelledby \code{string} \cr Default is - An id or list of ids separated by a space that label the Tabs.
\item centered \code{bool} \cr Default is FALSE If true, the tabs are centered. This prop is intended for large views.
\item children \code{node} \cr Default is - The content of the component.
\item classes \code{object} \cr Default is - Override or extend the styles applied to the component.See CSS classes API below for more details.
\item component \code{elementType} \cr Default is - The component used for the root node. Either a string to use a HTML element or a component.
\item indicatorColor \code{'primary'| 'secondary'| string} \cr Default is 'primary' Determines the color of the indicator.
\item onChange \code{func} \cr Default is - Callback fired when the value changes.Signature:function(event: React.SyntheticEvent, value: any) = voidevent The event source of the callback. Warning: This is a generic event not a change event.value We default to the index of the child (number)
\item orientation \code{'horizontal'| 'vertical'} \cr Default is 'horizontal' The component orientation (layout flow direction).
\item ScrollButtonComponent \code{elementType} \cr Default is TabScrollButton The component used to render the scroll buttons.Deprecated use the slots.scrollButtons prop instead. This prop will be removed in a future major release. See Migrating from deprecated APIs for more details.
\item scrollButtons \code{'auto'| false| true} \cr Default is 'auto' Determine behavior of scroll buttons when tabs are set to scroll: auto will only present them when not all the items are visible. true will always present them. false will never present them. By default the scroll buttons are hidden on mobile. This behavior can be disabled with allowScrollButtonsMobile.
\item selectionFollowsFocus \code{bool} \cr Default is - If true the selected tab changes on focus. Otherwise it only changes on activation.
\item slotProps \verb{\{ endScrollButtonIcon?: func| object, indicator?: func| object, list?: func| object, root?: func| object, scrollbar?: func| object, scrollButtons?: func| object, scroller?: func| object, startScrollButtonIcon?: func| object \}} \cr Default is The props used for each slot inside.
\item slots \verb{\{ endScrollButtonIcon?: elementType, EndScrollButtonIcon?: elementType, indicator?: elementType, list?: elementType, root?: elementType, scrollbar?: elementType, scrollButtons?: elementType, scroller?: elementType, startScrollButtonIcon?: elementType, StartScrollButtonIcon?: elementType \}} \cr Default is The components used for each slot inside.
\item sx \verb{Array func| object| bool | func| object} \cr Default is - The system prop that allows defining system overrides as well as additional CSS styles.See the \code{sx} page for more details.
\item TabIndicatorProps \code{object} \cr Default is Props applied to the tab indicator element.Deprecated use the slotProps.indicator prop instead. This prop will be removed in a future major release. See Migrating from deprecated APIs for more details.
\item TabScrollButtonProps \code{object} \cr Default is Props applied to the TabScrollButton element.Deprecated use the slotProps.scrollButtons prop instead. This prop will be removed in a future major release. See Migrating from deprecated APIs for more details.
\item textColor \code{'inherit'| 'primary'| 'secondary'} \cr Default is 'primary' Determines the color of the Tab.
\item value \code{any} \cr Default is - The value of the currently selected Tab. If you don't want any selected Tab, you can set this prop to false.
\item variant \code{'fullWidth'| 'scrollable'| 'standard'} \cr Default is 'standard' Determines additional display behavior of the tabs: scrollable will invoke scrolling properties and allow for horizontally scrolling (or swiping) of the tab bar. fullWidth will make the tabs grow to use all the available space, which should be used for small views, like on mobile. standard will render the default state.
\item visibleScrollbar \code{bool} \cr Default is FALSE If true, the scrollbar is visible. It can be useful when displaying a long vertical list of tabs.
}
}
