% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/documentation.R
\name{ButtonBase}
\alias{ButtonBase}
\title{ButtonBase}
\usage{
ButtonBase(...)
}
\arguments{
\item{...}{Props to pass to the component.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
}
\description{
\url{https://mui.com/material-ui/api/button-base/}
}
\details{
\itemize{
\item action \code{ref} \cr Default is - A ref for imperative actions. It currently only supports focusVisible() action.
\item centerRipple \code{bool} \cr Default is FALSE If true, the ripples are centered. They won't start at the cursor interaction position.
\item children \code{node} \cr Default is - The content of the component.
\item classes \code{object} \cr Default is - Override or extend the styles applied to the component.See CSS classes API below for more details.
\item component \verb{element type} \cr Default is - The component used for the root node. Either a string to use a HTML element or a component.This needs to be able to hold a ref.
\item disabled \code{bool} \cr Default is FALSE If true, the component is disabled.
\item disableRipple \code{bool} \cr Default is FALSE If true, the ripple effect is disabled.  Without a ripple there is no styling for :focus-visible by default. Be sure to highlight the element by applying separate styles with the .Mui-focusVisible class.
\item disableTouchRipple \code{bool} \cr Default is FALSE If true, the touch ripple effect is disabled.
\item focusRipple \code{bool} \cr Default is FALSE If true, the base button will have a keyboard focus ripple.
\item focusVisibleClassName \code{string} \cr Default is - This prop can help identify which element has keyboard focus. The class name will be applied when the element gains the focus through keyboard interaction. It's a polyfill for the CSS :focus-visible selector. The rationale for using this feature is explained here. A polyfill can be used to apply a focus-visible class to other components if needed.
\item LinkComponent \code{elementType} \cr Default is 'a' The component used to render a link when the href prop is provided.
\item onFocusVisible \code{func} \cr Default is - Callback fired when the component is focused with a keyboard. We trigger a onFocus callback too.
\item sx \verb{Array func| object| bool | func| object} \cr Default is - The system prop that allows defining system overrides as well as additional CSS styles.See the \code{sx} page for more details.
\item TouchRippleProps \code{object} \cr Default is - Props applied to the TouchRipple element.
\item touchRippleRef \verb{func| \{ current?: \{ pulsate: func, start: func, stop: func \} \}} \cr Default is - A ref that points to the TouchRipple element.
}
}
