% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sde.init.R
\name{sde.init}
\alias{sde.init}
\title{MCMC initialization.}
\usage{
sde.init(model, x, dt, m = 1, nvar.obs, theta)
}
\arguments{
\item{model}{An \code{sde.model} object.}

\item{x}{An \verb{nobs x ndims} matrix of data.}

\item{dt}{A scalar or length \code{nobs-1} vector of interobservations times.}

\item{m}{Positive integer, such that \code{m-1} evenly-spaced missing data time points are placed between observations.  See Details.}

\item{nvar.obs}{A scalar or length \code{nobs} vector of integers between 0 and \code{ndims} denoting the number of observed SDE variables in each row of \code{data}.  Defaults to \code{ndims}.  See Details.}

\item{theta}{A length \code{nparams} vector of parameter values.}
}
\value{
An \code{sde.init} object, corresponding to a list with elements:
\describe{
\item{\code{data}}{An \verb{ncomp x ndims} matrix of complete data, where \code{ncomp = N_m = m * (nobs-1)+1}.}
\item{\code{dt.m}}{The complete data interobservation time, \code{dt_m = dt/m}.}
\item{\code{nvar.obs.m}}{The number of variables observed per row of \code{data}.  Note that \code{nvar.obs.m[(i-1)*m+1] == nvar.obs[ii]}, and that \code{nvar.obs.m[i-1] == 0} if \code{i} is not a multiple of \code{m}.}
\item{\code{params}}{Parameter initial values.}
}
}
\description{
Specifies the observed SDE data, interobservation times, initial parameter and missing data values to be supplied to \code{\link[=sde.post]{sde.post()}}.
}
\examples{
# load Heston's model
hmod <- sde.examples("hest")

# generate some observed data
nObs <- 5
x0 <- c(X = log(1000), Z = 0.1)
X0 <- apply(t(replicate(nObs, x0)), 2, jitter)
dT <- .6
theta <- c(alpha = 0.1, gamma = 1, beta = 0.8, sigma = 0.6, rho = -0.8)

# no missing data
sde.init(model = hmod, x = X0, dt = dT, theta = theta)

# all but endpoint volatilities are missing
sde.init(model = hmod, x = X0, dt = dT, m = 1,
         nvar.obs = c(2, rep(1, nObs-2), 2), theta = theta)

# all volatilities missing,
# two completely missing SDE timepoints between observations
m <- 3 # divide each observation interval into m equally spaced timepoints
sde.init(model = hmod, x = X0, dt = dT,
         m = m, nvar.obs = 1, theta = theta)
}
