% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_mrgmod.R
\name{as.list,mrgmod-method}
\alias{as.list,mrgmod-method}
\title{Coerce a model object to list}
\usage{
\S4method{as.list}{mrgmod}(x, deep = FALSE, ...)
}
\arguments{
\item{x}{a model object.}

\item{deep}{if \code{TRUE}, extra information is returned in the output list
(see \strong{Details}).}

\item{...}{not used.}
}
\value{
A named list containing formatted contents from \code{x}.
}
\description{
Coerce a model object to list
}
\details{
If \code{deep} is \code{TRUE}, then the values for \code{trans}, \code{advan}, and \code{mindt} are
returned as well as a summary of internal model functions (with a call to
\code{mrgsolve:::funset()}).
}
\section{Slots}{

\itemize{
\item \code{npar}: number of parameters
\item \code{neq}: number of compartments or differential equations
\item \code{pars}: names of model parameters
\item \code{covariates}: names of parameters identified as covariates
\item \code{cmt}: names of model compartments
\item \code{param}: the parameter list
\item \code{init}: initial condition list
\item \code{omega}: \verb{$OMEGA} matrices, as a \code{matlist} object
\item \code{sigma}: \verb{$SIGMA} matrices, as a \code{matlist} object
\item \code{fixed}: named list of \verb{$FIXED} values
\item \code{model}: model name
\item \code{project}: model project directory
\item \code{soloc}: directory where the model is being built
\item \code{sodll}: complete path to the model shared object
\item \code{cfile}: path for the model source code file
\item \code{shlib}: list of compilation information
\item \code{start}: simulation start time
\item \code{end}: simulation end time
\item \code{delta}: simulation time step
\item \code{add}: additional simulation times
\item \code{capture}: names of captured data items
\item \code{request}: compartments requested upon simulation
\item \code{cmti}: named indices for current output compartments
\item \code{capturei}: named indices for current output capture
\item \code{random}: names and labels of \verb{$OMEGA} and \verb{$SIGMA}
\item \code{code}: model source code from \code{cfile}
\item \code{details}: model details data frame
\item \code{nm_import}: a character vector listing the names of nonmem output files
that were read to import estimates from a completed nonmem run
\item \code{cpp_variables}: a data frame listing variables internal to the model
cpp file
\item \code{atol}: see \link{solversettings}
\item \code{rtol}: see \link{solversettings}
\item \code{ss_atol}: absolute tolerance to use when advancing to PK steady state
\item \code{ss_rtol}: relative tolerance to use when advancing to PK steady state
\item \code{custom_atol}: absolute tolerances, one for each compartment
\item \code{custom_rtol}: relative tolerances, one for each compartment
\item \code{maxsteps}: see \link{solversettings}
\item \code{hmin}: see \link{solversettings}
\item \code{hmax}: see \link{solversettings}
\item \code{itol}: 1 (use scalar values) or 4 (use customized values)
\item \code{itol_type}: either "scalar" (\code{itol = 1}) or "custom" (\code{itol = 4})
\item \code{envir}: the model environment
\item \code{plugins}: plugins invoked in the model
\item \code{digits}: number of digits to request in simulated data
\item \code{tscale}: multiplicative scalar for time in results only
\item \code{mindt}: simulation output time below which there model will assume to
have not advanced
\item \code{preclean}: logical indicating to clean up compilation artifacts prior
to compiling
\item \code{debug}: print debugging information during simulation run
\item \code{verbose}: print extra information during setup for model run
}
}

\examples{
mod <- mrgsolve::house()
l <- as.list(mod)

}
