% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq.R
\name{seq_fct}
\alias{seq_fct}
\title{Generate a sequence by fold increase and decrease from a point}
\usage{
seq_fct(point, n = 5, factor = c(3, 3), geo = TRUE, digits = NULL)
}
\arguments{
\item{point}{a numeric vector of length 1.}

\item{n}{number of elements in the sequence.}

\item{factor}{an integer vector of length 1 or 2; if length 1,
values will be recycled to length 2; the first number used to divide
\code{point} to generate the minimum value in the sequence; the second
number is used to multiply \code{point} to generate the
maximum value in the sequence.}

\item{geo}{if \code{TRUE}, \code{\link[=seq_geo]{seq_geo()}} is used to generate
the sequence; otherwise, \code{\link[=seq_even]{seq_even()}} is used to generate
the sequence.}

\item{digits}{number of significant digits in the answer; if \code{NULL} (the
default) all digits are retained.}
}
\description{
Generate a sequence by fold increase and decrease from a point
}
\examples{
seq_fct(10)

seq_fct(10, n = 4, factor = 2)

seq_fct(10, n = 4, factor = 2, geo = TRUE)

}
