% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_gaz_sources.R
\name{gaz_search_by_source}
\alias{gaz_search_by_source}
\alias{gaz_search_by_source.character}
\alias{gaz_search_by_source.numeric}
\title{Retrieve Gazetteer Records by Source}
\usage{
gaz_search_by_source(x, ...)

\method{gaz_search_by_source}{character}(x, ...)

\method{gaz_search_by_source}{numeric}(x, ...)
}
\arguments{
\item{x}{source as free text or \code{sourceID} as integer}

\item{...}{
  Arguments passed on to \code{\link[=gaz_rest_records_by_source]{gaz_rest_records_by_source}}
  \describe{
    \item{\code{with_geometry}}{(logical) Add geometries to the result data frame? Default = FALSE}
  }}
}
\value{
A data frame with Gazetteer entries
}
\description{
Retrieve Gazetteer Records by Source
}
\examples{
\donttest{
# Check out all sources
gaz_sources()

# Look up by source name
gaz_search_by_source("Gazetteer of Greenland")

# Or query by SourceID
gaz_search_by_source(386)
}
}
\seealso{
\code{\link[=gaz_sources]{gaz_sources()}}
}
