% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solvecov.R
\name{solvecov}
\alias{solvecov}
\title{Invert of covariance matrices}
\usage{
solvecov(m, cmax = 1e+10)
}
\arguments{
\item{m}{a numeric symmetric matrix.}

\item{cmax}{a positive value, see above.}
}
\value{
A list with the following components: \code{inv} the inverted
matrix, \code{coll} \code{TRUE} if \code{solve} failed because of
singularity.
}
\description{
Tries to invert a matrix by \code{solve}. If this fails because of
singularity, an eigenvector decomposition is computed, and eigenvalues below
\code{1/cmax} are replaced by \code{1/cmax}, i.e., \code{cmax} will be the
corresponding eigenvalue of the inverted matrix.
}
\section{Source}{

\code{solvecov} code was taken from package \code{fpc}: Christian Hennig
}

\seealso{
solve, eigen
}
\author{
Christian Hennig
}
