% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{readSnpsPed}
\alias{readSnpsPed}
\title{Conversion to single column per locus from plink file via LEA functionality}
\usage{
readSnpsPed(pedfile, mapfile)
}
\arguments{
\item{pedfile}{A file location.}

\item{mapfile}{A file location.}
}
\value{
A tibble.
}
\description{
Conversion to single column per locus from plink file via LEA functionality
}
\details{
Function to import SNP data from a plink format into a format
suitable for MrIML predicts (presence/absence of an alelle for each locus).
Currently if there is missing data (NAs) it either imputes them as the mode
or leaves them. A histogram is also produced of the missing data.
}
\examples{
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
snps <- readSnpsPed("FILE_NAME.plink.ped", "FILE_NAME.plink.map.map")
X <- filterRareCommon(snps, lower = 0.4, higher = 0.7)
\dontshow{\}) # examplesIf}
}
