% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mppGE_SIM.R
\name{mppGE_SIM}
\alias{mppGE_SIM}
\title{MPP GxE Simple Interval Mapping}
\usage{
mppGE_SIM(
  mppData,
  trait,
  VCOV = "UN",
  ref_par = NULL,
  n.cores = 1,
  maxIter = 100,
  msMaxIter = 100
)
}
\arguments{
\item{mppData}{An object of class \code{mppData}.}

\item{trait}{\code{Character vector} specifying which traits (environments)
should be used.}

\item{VCOV}{VCOV \code{Character} expression defining the type of variance
covariance structure used. 'CS' for compound symmetry assuming a unique
genetic covariance between environments. 'CSE' for cross-specific within
environment error term. 'CS_CSE' for both compound symmetry plus
cross-specific within environment error term. 'UN' for unstructured
environmental variance covariance structure allowing a specific genotypic
covariance for each pair of environments. Default = 'UN'}

\item{ref_par}{Optional \code{Character} expression defining the parental
allele that will be used as reference for the parental model. Default = NULL}

\item{n.cores}{\code{Numeric}. Specify here the number of cores you like to
use. Default = 1.}

\item{maxIter}{maximum number of iterations for the lme optimization algorithm.
Default = 100.}

\item{msMaxIter}{maximum number of iterations for the optimization step inside
the lme optimization. Default = 100.}
}
\value{
Return:

\item{SIM }{\code{Data.frame} of class \code{QTLprof}. with five columns :
1) QTL marker or in between position names; 2) chromosomes;
3) integer position indicators on the chromosome;
4) positions in centi-Morgan; and 5) -log10(p-val) of the global QTL effect
across environments 6) p-values of the within environment QTL effects
(one column per environment); and p-values of the within environment parental
QTL allelic effects (one column per parent environment combination).}
}
\description{
Computes single QTL models along the genome using an approximate mixed model
computation. An initial variance covariance (VCOV) structure is calculated
using function from the \code{nlme} package. Then, this information is used
to estimate the QTL global and within parental effect significance using a
Wald test.
}
\details{
The estimated model is the following:

\eqn{\underline{y}_{icj} = E_{j} + C_{cj} + x_{i_{q}p} * \beta_{pj} + \underline{GE}_{icj} + \underline{e}_{icj}}

For further details see the vignette.
}
\examples{

data(mppData_GE)

SIM <- mppGE_SIM(mppData = mppData_GE, trait = c('DMY_CIAM', 'DMY_TUM'))

Qpos <- QTL_select(Qprof = SIM, threshold = 3, window = 50)

plot(x = SIM, QTL = Qpos)

plot_allele_eff_GE(mppData = mppData_GE, nEnv = 2, EnvNames = c('CIAM', 'TUM'),
                   Qprof = SIM, Q.eff = 'par', QTL = Qpos, text.size = 14)

}
\references{
Pinheiro J, Bates D, DebRoy S, Sarkar D, R Core Team (2021). nlme: Linear
and Nonlinear Mixed Effects Models_. R package version 3.1-152,
<URL: https://CRAN.R-project.org/package=nlme>.
}
\seealso{
\code{\link{mppGE_CIM}},
\code{\link{mppGE_proc}}
}
\author{
Vincent Garin
}
