% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.mpolyList.R
\name{print.mpolyList}
\alias{print.mpolyList}
\title{Pretty printing of a list of multivariate polynomials.}
\usage{
\method{print}{mpolyList}(
  x,
  varorder = vars(x),
  stars = FALSE,
  order,
  silent = FALSE,
  ...,
  plus_pad = 2L,
  times_pad = 1L
)
}
\arguments{
\item{x}{an object of class mpoly}

\item{varorder}{the order of the variables}

\item{stars}{print the multivariate polynomial in the more computer-friendly
asterisk notation (default FALSE)}

\item{order}{a total order used to order the monomials in the printing}

\item{silent}{logical; if TRUE, suppresses output}

\item{...}{additional parameters to go to \code{\link[base:cat]{base::cat()}}}

\item{plus_pad}{number of spaces to the left and right of plus sign}

\item{times_pad}{number of spaces to the left and right of times sign}
}
\value{
Invisible character vector of the printed objects.
}
\description{
This function iterates print.mpoly on an object of class mpolyList.
}
\examples{

mL <- mp(c("x + 1", "y - 1", "x y^2 z  +  x^2 z^2  +  z^2  +  x^3"))
mL
print(mL, order = "lex")
print(mL, order = "glex")
print(mL, order = "grlex")
print(mL, order = "glex", varorder = c("z","y","x"))
print(mL, order = "grlex", varorder = c("z","y","x"))
print(mL, varorder = c("z","y","x"))

(print(mL, varorder = c("z","y","x"), plus_pad = 1L, silent = TRUE))

(print(mL, silent = TRUE, stars = TRUE, plus_pad = 1L, times_pad = 0L))

}
