% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_ci_U.R
\name{compute_ci_U}
\alias{compute_ci_U}
\title{Compute 95\% confidence intervals for derived estimates from the U submatrix
of a matrix population model}
\usage{
compute_ci_U(mat_U, sample_size, FUN, ..., n_sim = 1000, dist.out = FALSE)
}
\arguments{
\item{mat_U}{A matrix that describes the growth and survival process.}

\item{sample_size}{either (1) a single matrix of sample sizes for each
element of the U matrix, (2) a single value applied to the whole matrix}

\item{FUN}{A function to apply to each simulated matrix population model.
This function must take, as input, a single U submatrix of a matrix
population model (i.e., the U matrix). For functions that require the A
matrix, use \code{compute_ci}.}

\item{...}{Additional arguments to be passed to \code{FUN}.}

\item{n_sim}{An integer indicating the number of simulations to run. Default
is 1000.}

\item{dist.out}{Logical. If TRUE, returns a list with both the quantiles and
the simulated estimates. Default is FALSE.}
}
\value{
If dist.out is FALSE, a numeric vector of the 2.5th and 97.5th
quantiles of the estimated measures. If \code{dist.out = TRUE}, a list with two
elements: \code{quantiles} and \code{estimates}. \code{quantiles} is a numeric vector of
the 2.5th and 97.5th quantiles of the estimated measures, and \code{estimates}
is a numeric vector of the estimated measures.
}
\description{
This function computes the 95\% confidence interval for measures derived from
the U submatrix of a matrix population model using parametric bootstrapping.
In this approach a sampling distribution of the U submatrix is generated by
taking a large number of random independent draws using the sampling
distribution of each underlying transition rate. The approach rests on our
assumption that survival-related processes are binomial (see the function
\code{add_mpm_error()} for details).
}
\details{
The main inputs is the U matrix, which describes the survival-related
processes. The underlying assumption is that the U matrix is the average of a
binomial process. The confidence interval will depend largely on the sample
size used.
}
\examples{
set.seed(42) # set seed for repeatability

# Data for use in example
matU <- matrix(c(
  0.1, 0.0,
  0.2, 0.4
), byrow = TRUE, nrow = 2)


# Example of use to calculate 95\% CI of life expectancy
compute_ci_U(
  mat_U = matU, sample_size = 10, FUN =
    Rage::life_expect_mean
)

# Example of use to calculate 95\% CI of generation time and show the
# distribution of those bootstrapped estimates
xx <- compute_ci_U(
  mat_U = matU, sample_size = 100, FUN =
    Rage::life_expect_mean, dist.out = TRUE
)

summary(xx$quantiles)
hist(xx$estimates)

}
\references{
Chapter 12 in Caswell, H. (2001). Matrix Population Models.
Sinauer Associates Incorporated.
}
\seealso{
Other errors: 
\code{\link{add_mpm_error}()},
\code{\link{calculate_errors}()},
\code{\link{compute_ci}()}
}
\author{
Owen Jones \href{mailto:jones@biology.sdu.dk}{jones@biology.sdu.dk}
}
\concept{errors}
