% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmfence.R
\name{lmfence}
\alias{lmfence}
\title{The fence procedure for linear models}
\usage{
lmfence(mf, cstar, nvmax, adaptive = TRUE, trace = TRUE, force.in = NULL, ...)
}
\arguments{
\item{mf}{an object of class \code{\link[stats]{lm}}
specifying the full model.}

\item{cstar}{the boundary of the fence, typically found
through bootstrapping.}

\item{nvmax}{the maximum number of variables that will be
be considered in the model.}

\item{adaptive}{logical. If \code{TRUE} the boundary of the fence is
given by cstar.  Otherwise, it the original (non-adaptive) fence
is performed where the boundary is cstar*hat(sigma)_{M,tildeM}.}

\item{trace}{logical. If \code{TRUE} the function prints out its
progress as it iterates up through the dimensions.}

\item{force.in}{the names of variables that should be forced
into all estimated models.}

\item{...}{further arguments (currently unused)}
}
\description{
This function implements the fence procedure to
find the best linear model.
}
\examples{
n = 40 # sample size
beta = c(1,2,3,0,0)
K=length(beta)
set.seed(198)
X = cbind(1,matrix(rnorm(n*(K-1)),ncol=K-1))
e = rnorm(n)
y = X\%*\%beta + e
dat = data.frame(y,X[,-1])
# Non-adaptive approach (not recommended)
lm1 = lm(y~.,data=dat)
lmfence(lm1,cstar=log(n),adaptive=FALSE)
}
\references{
Jiming Jiang, Thuan Nguyen, J. Sunil Rao,
A simplified adaptive fence procedure, Statistics &
Probability Letters, Volume 79, Issue 5, 1 March 2009,
Pages 625-629, http://dx.doi.org/10.1016/j.spl.2008.10.014.
}
\seealso{
\code{\link{af}}, \code{\link{glmfence}}

Other fence: 
\code{\link{af}()},
\code{\link{glmfence}()}
}
\concept{fence}
\keyword{Internal}
