% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaled.coef.R
\name{scaled.coef}
\alias{scaled.coef}
\alias{scaled.coef.default}
\title{Scaled (standardized) coefficients}
\usage{
scaled.coef(object, ...)

\method{scaled.coef}{default}(object, scale.response = TRUE, complete = FALSE, ...)
}
\arguments{
\item{object}{an object for which the extraction of model coefficients is
meaningful.}

\item{...}{further arguments passed to or from other methods.}

\item{scale.response}{logical indicating if the response variable should be
standardized.}

\item{complete}{for the default (used for lm, etc) and aov methods: logical
indicating if the full coefficient vector should be returned also in case of
an over-determined system where some coefficients will be set to \link{NA}.}
}
\value{
A named vector with the scaled coefficients.
}
\description{
Computes the standardized (regression) coefficients, also called beta
coefficients or beta weights, to quantify the importance (the effect) of the
predictors on the dependent variable in a multiple regression analysis where
the variables are measured in different units.
}
\details{
The beta weights are the coefficient estimates resulting from a regression
analysis where the underlying data have been standardized so that the
variances of dependent and explanatory variables are equal to 1.
Therefore, standardized coefficients are unitless and refer to how many
standard deviations a dependent variable will change, per standard deviation
increase in the predictor variable.
See \url{https://en.wikipedia.org/wiki/Standardized_coefficient} or
\href{https://rdrr.io/cran/QuantPsyc/man/lm.beta.html}{\code{QuantPsyc::lm.beta}}.

Based on \href{https://rdrr.io/cran/QuantPsyc/man/lm.beta.html}{\code{QuantPsyc::lm.beta}}.
}
\examples{
fit <- lm(fidelida ~ velocida + calidadp, hbat)
coef(fit)
scaled.coef(fit)
fit2 <- lm(scale(fidelida) ~ scale(velocida) + scale(calidadp), hbat)
coef(fit2)
fit3 <- lm(fidelida ~ scale(velocida) + scale(calidadp), hbat)
coef(fit3)
scaled.coef(fit, scale.response = FALSE)
}
\seealso{
\code{\link[=coef]{coef()}}
}
