% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/granger.R
\name{plot.GrangerInteraction}
\alias{plot.GrangerInteraction}
\title{Plot network diagram of Granger Causalities}
\usage{
\method{plot}{GrangerInteraction}(x, mfrow = NULL, mar = c(1, 1, 1, 1), oma = c(1, 1, 1, 1), ...)
}
\arguments{
\item{x}{GrangerInteration object}

\item{mfrow}{passed to \code{\link[=par]{par()}}}

\item{mar}{passed to \code{\link[=par]{par()}}}

\item{oma}{passed to \code{\link[=par]{par()}}}

\item{...}{passed through to \link[igraph]{plot.igraph}}
}
\value{
data.frame of P-Values
}
\description{
Plot network diagram of Granger Causalities
}
\examples{
r <- get_recording("NIR_ABh_Puriya", fps = 25)
fv_list <- get_filtered_views(r, "Nose", n = 41, p = 3)
jv <- get_joined_view(fv_list)
jv <- subset(jv, Time <= 5*60)
l <- list(a = c(0, 100), b = c(100, 200), c = c(200, 300))
splicing_df <- splice_time(l)
sv <- get_spliced_view(jv, splicing_df)
gi <- get_granger_interactions(sv, c("Nose_x_Central_Sitar", "Nose_x_Central_Tabla"), lag = 1/25)
print(gi)
}
\seealso{
Other Granger Causality: 
\code{\link{autoplot.GrangerTime}()},
\code{\link{get_granger_interactions}()},
\code{\link{granger_test}()},
\code{\link{map_to_granger_test}()},
\code{\link{ms_condgrangertest}()},
\code{\link{ms_grangertest1}()},
\code{\link{ms_grangertest2}()},
\code{\link{plot_influence_diagram}()}
}
\concept{Granger Causality}
