% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequencyPolygon.R
\name{freqpolygon}
\alias{freqpolygon}
\alias{prepanel.default.freqpolygon}
\alias{panel.freqpolygon}
\title{Frequency Polygons}
\usage{
freqpolygon(
  x,
  ...,
  panel = "panel.freqpolygon",
  prepanel = "prepanel.default.freqpolygon"
)

prepanel.default.freqpolygon(
  x,
  darg = list(),
  plot.points = FALSE,
  ref = FALSE,
  groups = NULL,
  subscripts = TRUE,
  jitter.amount = 0.01 * diff(current.panel.limits()$ylim),
  center = NULL,
  nint = NULL,
  breaks = NULL,
  width = darg$width,
  type = "density",
  ...
)

panel.freqpolygon(
  x,
  darg = list(),
  plot.points = FALSE,
  ref = FALSE,
  groups = NULL,
  weights = NULL,
  jitter.amount = 0.01 * diff(current.panel.limits()$ylim),
  type = "density",
  breaks = NULL,
  nint = NULL,
  center = NULL,
  width = darg$width,
  gcol = trellis.par.get("reference.line")$col,
  glwd = trellis.par.get("reference.line")$lwd,
  h,
  v,
  ...,
  identifier = "freqpoly"
)
}
\arguments{
\item{x}{a formula or a numeric vector}

\item{\dots}{additional arguments passed on to \code{\link[=histogram]{histogram()}}
and \code{panel}.}

\item{panel}{a panel function}

\item{prepanel}{a prepanel function}

\item{darg}{a list of arguments for the function computing the frequency polygon.
This exists primarily for compatibility with \code{densityplot} and is unlikely
to be needed by the end user.}

\item{plot.points}{one of \code{TRUE}, \code{FALSE}, \code{"jitter"}, or \code{"rug"} indicating
how points are to be displayed}

\item{ref}{a logical indicating whether a horizontal reference line should be
added (roughly equivalent to \code{h=0})}

\item{groups, weights, jitter.amount, identifier}{as in \code{\link[lattice:histogram]{lattice::densityplot()}}
or \code{\link[=histogram]{histogram()}}}

\item{subscripts}{as in other lattice prepanel functions}

\item{center}{center of one of the bins}

\item{nint}{an approximate number of bins for the frequency polygon}

\item{breaks}{a vector of breaks for the frequency polygon bins}

\item{width}{width of the bins}

\item{type}{one of \code{'density'}, \code{'percent'}, or \code{'count'}}

\item{gcol}{color of guidelines}

\item{glwd}{width of guidelines}

\item{h, v}{a vector of values for additional horizontal and vertical lines}
}
\value{
a trellis object
}
\description{
Frequency polygons are an alternative to histograms that make it simpler to overlay multiple
distributions.
}
\note{
This function make use of \code{histogram} to determine overall layout.  Often
this works reasonably well but sometimes it does not. In particular, when \code{groups} is
used to overlay multiple frequency polygons, there is often too little head room.
In the latter cases, it may be
necessary to use \code{ylim} to determine an appropriate viewing rectangle for the
plot.
}
\examples{
freqpolygon(~age | substance, data=HELPrct, v=35)
freqpolygon(~age, data=HELPrct, labels=TRUE, type='count')
freqpolygon(~age | substance, data=HELPrct, groups=sex)
freqpolygon(~age | substance, data=HELPrct, groups=sex, ylim=c(0,0.11))
## comparison of histogram and frequency polygon
histogram(~eruptions, faithful, type='density', width=.5)
ladd( panel.freqpolygon(faithful$eruptions, width=.5 ))
}
