% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mPlots.R
\name{design_plot}
\alias{design_plot}
\title{Interactively design plots}
\usage{
design_plot(
  data,
  format,
  default = format,
  system = system_choices()[1],
  show = FALSE,
  title = "",
  data_text = rlang::expr_deparse(substitute(data)),
  ...
)
}
\arguments{
\item{data}{a data frame containing the variables that might be used in the plot.
Note that for maps, the data frame must contain coordinates of the polygons
comprising the map and a variable for determining which coordinates are part
of the same region.  See \code{\link[=sp2df]{sp2df()}} for one way to create such
a data frame.  Typically \code{\link[=merge]{merge()}} will be used to combine the map
data with some auxiliary data to be displayed as fill color on the map, although
this is not necessary if all one wants is a map.}

\item{format}{a synonym for \code{default}.}

\item{default}{default type of plot to create; one of
\code{"scatter"},
\code{"jitter"},
\code{"boxplot"},
\code{"violin"},
\code{"sina"},
\code{"histogram"},
\code{"density"},
\code{"density (contours)"},
\code{"density (filled)"},
\code{"frequency polygon"},
\code{"xyplot"},
or
\code{"map"}.  Unique prefixes suffice.}

\item{system}{which graphics system to use (initially) for plotting (\pkg{ggplot2}
or \pkg{lattice}).  A check box will allow on the fly change of plotting system.}

\item{show}{a logical, if \code{TRUE}, the code will be displayed each time the plot is
changed.}

\item{title}{a title for the plot}

\item{data_text}{A text string describing the data.  It must be possible to recover the data
from this string using \code{\link[=eval]{eval()}}.  Typically users will not need to
modify this from the default value.}

\item{...}{additional arguments}
}
\value{
Nothing.  Used for side effects.
}
\description{
Proves a simple interface to let users interactively design plots in \pkg{ggformula}, \pkg{lattice}, or \pkg{ggplot2}.
An option is available to show the code used to create the plot.
This can be copied and pasted elsewhere to (into an RMarkdown document, for example) to recreate the plot.
Only works in RStudio. Requires the \pkg{manipulate} package.
}
\details{
Currently maps are only supported in \pkg{ggplot2} and not in \pkg{lattice}.

Due to an unresolved issue with RStudio, the first time this function is called, and additional
plot is created to correctily initialize the mainipulate frameowrk.
}
\examples{
\dontrun{
  mtcars2 <- 
    mtcars |> 
      mutate(
        cyl2 = factor(cyl), 
        carb2 = factor(carb),
        shape = c("V-shaped", "straight")[1 + vs], 
        gear2 = factor(gear), 
        transmission = c("automatic", "manual")[1 + am])
  design_plot(mtcars2)
}
}
