% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/props-counts.R
\name{counts}
\alias{counts}
\alias{counts.factor}
\alias{counts.default}
\alias{counts.formula}
\alias{props}
\alias{percs}
\title{Compute all proportions or counts}
\usage{
counts(x, ...)

\method{counts}{factor}(x, ..., format = c("count", "proportion", "percent"))

\method{counts}{default}(x, ..., format = c("count", "proportion", "percent"))

\method{counts}{formula}(x, data, ..., format = "count")

props(x, ..., format = "proportion")

percs(x, ..., format = "percent")
}
\arguments{
\item{x}{A vector or a formula.}

\item{...}{Arguments passed to methods.}

\item{format}{One of \code{"count"}, \code{"proportion"}, or \code{"percent"}.  May be abbreviated.}

\item{data}{A data frame.}
}
\description{
Compute vector of counts, proportions, or percents for each unique value (and \code{NA} if there
is missing data) in a vector.
}
\examples{
if (require(mosaicData)) {
  props(HELPrct$substance)
  # numeric version tallies missing values as well
  props(HELPmiss$link)
  # Formula version omits missing data with warning (by default)
  props( ~ link, data = HELPmiss)                       # omit NAs with warning
  props( ~ link, data = HELPmiss, na.action = na.pass)  # no warning; tally NAs
  props( ~ link, data = HELPmiss, na.action = na.omit)  # no warning, omit NAs
  props( ~ substance | sex, data = HELPrct)
  props( ~ substance | sex, data = HELPrct, format = "percent")
  percs( ~ substance | sex, data = HELPrct)
  counts( ~ substance | sex, data = HELPrct)
  df_stats( ~ substance | sex, data = HELPrct, props, counts)
  df_stats( ~ substance | sex, data = HELPmiss, props, na.action = na.pass)
}

}
\seealso{
\code{\link[mosaic:reexports]{mosaic::prop()}}

\code{\link[mosaic:reexports]{mosaic::count()}}
}
