% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lpx.R
\name{LPxt}
\alias{LPxt}
\alias{lpxt}
\alias{lpxt.SurvFit}
\alias{update.LPxt}
\title{Lethal Profile calculation}
\usage{
lpxt(fit, x, ...)

\method{lpxt}{SurvFit}(
  fit,
  x = 0.5,
  t = NULL,
  display.exposure = NULL,
  interpolate_length = NULL,
  max.steps = 100,
  accuracy = 0.01,
  ...
)

\method{update}{LPxt}(object, accuracy = 0.01, max.steps = 100, ...)
}
\arguments{
\item{fit}{An object used to select a method}

\item{x}{rate of individuals dying (e.g., \eqn{0.5} for
\eqn{LP_{50}}, \eqn{0.1} for \eqn{LP_{10}}, ...).}

\item{\dots}{Further arguments to be passed to generic methods}

\item{t}{A number giving the time at which  \eqn{LP_{x}} has to be estimated.
If NULL, the latest time point of the experiment is used.}

\item{display.exposure}{A vector of the exposure porfile}

\item{interpolate_length}{of time point in the range of concentration between 0
and the maximal concentration. 100 by default. description.}

\item{max.steps}{max steps to find the LPxt}

\item{accuracy}{accuracy of the LPxt algorithm (stop when reaching the accuracy).}

\item{object}{An object of class \code{LPx}}
}
\value{
returns an object of class \code{LPxt}
}
\description{
Predict the Lethal Profile factor leading to $x$ \% of reduction in survival
at a specific time $t$.

Generic method for \code{LPxt}, a function denoted \eqn{LP(x,t)} for
\eqn{x}\\% Multiplication Factor at time \eqn{t}.
}
