% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_xml.R
\name{xml_image}
\alias{xml_image}
\title{Generate HTML and XML Representations for an Image}
\usage{
xml_image(image, image_alt, adapt_images = FALSE, width = NULL, height = NULL)
}
\arguments{
\item{image}{\code{character}
Path to the image file. If the string is empty, the function returns empty values.}

\item{image_alt}{\code{character}
Alternative text for the image, used for accessibility purposes (e.g., screen readers).}

\item{adapt_images}{\code{logical}, default \code{FALSE}
If \code{TRUE}, the image dimensions are adjusted to the specified \code{width} and \code{height}.
If \code{FALSE}, the original dimensions are used.}

\item{width}{\code{numeric} or \code{NULL}, default \code{NULL}
Desired width for the image. Only used when \code{adapt_images = TRUE}. If \code{NULL},
the width is derived from the image file.}

\item{height}{\code{numeric} or \code{NULL}, default \code{NULL}
Desired height for the image. Only used when \code{adapt_images = TRUE}. If \code{NULL},
the height is derived from the image file.}
}
\value{
A list with two elements:
\describe{
\item{\code{img}}{\code{character}: HTML string containing the \verb{<img>} tag.}
\item{\code{fimg}}{\code{character}: XML string containing the base64-encoded \verb{<file>} tag.}
}
}
\description{
This function generates an HTML \verb{<img>} tag and an XML \verb{<file>} tag for a given image.
The image can be processed to adjust its dimensions and encoded in base64 for embedding.
}
\details{
\itemize{
\item If \code{adapt_images = TRUE}, the function resizes the image using the specified dimensions.
\item If \code{adapt_images = FALSE}, the function reads the image's original dimensions and uses them.
\item The image is embedded as a base64 string in the \verb{<file>} tag for compatibility with XML-based systems.
}
}
\keyword{internal}
