% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/question_category_generation.R
\name{generate_xml}
\alias{generate_xml}
\alias{generate_xml.question_category}
\title{Generate questions xml string}
\usage{
generate_xml(qc)

\method{generate_xml}{question_category}(qc)
}
\arguments{
\item{qc}{A \code{question_category} object.}
}
\value{
A string.
}
\description{
Generate questions xml string
}
\examples{

qc <- question_category(category = 'Initial test') |>
  define_question(
    question = 'What are the basic arithmetic operations?',
    answer = 'Addition, subtraction, multiplication and division.',
    a_1 = 'Addition and subtraction.',
    a_2 = 'Addition, subtraction, multiplication, division and square root.'
  )

xml <- qc |>
  generate_xml()

}
\seealso{
Other question definition functions: 
\code{\link{define_extended_question}()},
\code{\link{define_question}()},
\code{\link{define_questions_from_csv}()},
\code{\link{define_questions_from_data_frame}()},
\code{\link{define_questions_from_excel}()},
\code{\link{generate_xml_file}()},
\code{\link{question_category}()}
}
\concept{question definition functions}
