% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/px_meta.R
\name{nso_table_meta}
\alias{nso_table_meta}
\title{Table metadata as per-dimension codebooks}
\usage{
nso_table_meta(tbl_id)
}
\arguments{
\item{tbl_id}{Table identifier (e.g., "DT_NSO_0300_001V2").}
}
\value{
A tibble with columns: \code{dim} (display name), \code{code} (dimension code),
\code{is_time} (logical), \code{n_values} (integer), and \code{codes} (list of tibbles).
}
\description{
Returns a tibble with one row per dimension and a \code{codes} list-column,
where each element is a tibble of codes and labels (\code{code}, \code{label_en},
\code{label_mn}). Useful for manual query assembly and for inspecting available
categories per dimension.
}
\examples{
\dontshow{if (curl::has_internet()) withAutoprint(\{ # examplesIf}
meta <- nso_table_meta("DT_NSO_0300_001V2")
meta
\dontshow{\}) # examplesIf}
}
