% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monaco.R
\name{monaco}
\alias{monaco}
\title{Monaco editor}
\usage{
monaco(
  contents,
  language = NULL,
  theme = NULL,
  tabSize = NULL,
  fontSize = 14,
  header = TRUE,
  width = NULL,
  height = NULL,
  elementId = NULL
)
}
\arguments{
\item{contents}{this can be the path to a file, \code{NULL} to open an
empty editor, missing to open the file currently open in RStudio, or a
character vector which corresponds to the lines of a file}

\item{language}{the language of the contents; if \code{NULL} and the
contents are read from a file, the mode is guessed from the extension of
the file; run \code{\link{getMonacoLanguages}} to get the list of
available languages}

\item{theme}{the theme of the editor; run \code{\link{getMonacoThemes}} to
get the list of available themes}

\item{tabSize}{number of spaces for the indentation (usually \code{2} or
\code{4}); if \code{NULL}, it is set to the one used in RStudio}

\item{fontSize}{font size in pixels}

\item{header}{logical, whether to display the header of the widget}

\item{width, height}{dimensions; the default values are nice for usage in
the RStudio viewer pane}

\item{elementId}{a HTML id for the container; this is useless for common
usage}
}
\description{
Open the Monaco editor.
}
\examples{
# in RStudio, `monaco()` opens the current file:
monaco()

# opens a new, empty JavaScript file:
monaco(NULL, language = "javascript")

# opens an existing file:
monaco(system.file("exampleFiles", "JavaScript.js", package = "monaco"))

# try the SVG viewer; you can zoom and pan the image:
monaco(system.file("exampleFiles", "react.svg", package = "monaco"))

# a dirty Markdown file, try to prettify it:
monaco(system.file("exampleFiles", "Markdown.md", package = "monaco"))


# opens two editors side-by-side:
library(monaco)
library(htmltools)

ed1 <- monaco(
  system.file("exampleFiles", "JavaScript.js", package = "monaco")
)
ed2 <- monaco(
  system.file("exampleFiles", "react.svg", package = "monaco")
)

if(interactive()){
  browsable(
    div(
      div(ed1, style="position: fixed; left: 1vw; right: 51vw;"),
      div(ed2, style="position: fixed; left: 51vw; right: 1vw;")
    )
  )
}


# stacks two editors:
library(monaco)
library(htmltools)

ed1 <- monaco(
  system.file("exampleFiles", "JavaScript.js", package = "monaco"),
  height = "calc(50vh - 40px)"
)
ed2 <- monaco(
  system.file("exampleFiles", "react.svg", package = "monaco"),
  height = "calc(50vh - 40px)"
)

if(interactive()){
  browsable(
    tagList(
      tags$style(HTML(
        ".editor {",
        "  position: fixed;",
        "  left: 1vw;",
        "  width: 98vw;",
        "}"
      )),
      div(
        div(ed1, class = "editor", style = "bottom: calc(50vh + 5px);"),
        div(ed2, class = "editor", style = "top: calc(50vh + 5px);")
      )
    )
  )
}
}
