% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centralityClustering.R
\name{CentClust}
\alias{CentClust}
\alias{centAuto}
\alias{clustAuto}
\title{Node centrality, clustering coefficients, and shortest path lengths}
\usage{
centAuto(x, which.net = "temporal", weighted = TRUE, signed = TRUE)

clustAuto(x, thresholdWS = 0, thresholdON = 0)
}
\arguments{
\item{x}{Output from one of the primary \code{modnets} functions. Can also
supply a list of network models, and the function will be applied to all
models in the list.}

\item{which.net}{Only applies to SUR networks, as well as those fit with the
\code{\link{mlGVAR}} function. Character string to indicate which type of
network to compute centrality values for. Options are \code{"temporal"} for
the temporal network, \code{"contemporaneous"} for the contemporaneous
network, \code{"PDC"} for the partial directed correlation network, and
\code{"interactions"} for the temporal interaction network.}

\item{weighted}{Logical. If \code{TRUE} then results are converted to an
unweighted network.}

\item{signed}{Logical. Determines whether to ignore the signs of edges or
not. Primarily affects the output for expected influence statistics.}

\item{thresholdWS}{Numeric threshold for the WS values.}

\item{thresholdON}{Numeric threshold for the Zhang values.}
}
\value{
A list containing node centrality statistics, edge-betweenness
values, and shortest path lengths.
}
\description{
Mimics the \code{\link[qgraph:centrality_auto]{qgraph::centrality_auto}} and
\code{\link[qgraph:clustcoef_auto]{qgraph::clustcoef_auto}} functions. The
purpose of amending these functions was to make them compatible with outputs
from the \code{modnets} package. The main use of these functions is as the
engines for the \code{\link{centTable}} and \code{\link{clustTable}}
functions.
}
\details{
Returns several node centrality statistics, edge-betweenness centrality, and
shortest path lengths. Betweenness and Closeness centrality are computed for
all types of networks, as well as edge-betweenness values and shortest path
lengths. For GGMs, Strength centrality and Expected Influence are also
computed. For SUR networks, InStrength, OutStrength, InExpectedInfluence, and
OutExpectedInfluence are computed instead.

The key distinction between these functions and the
\code{\link[qgraph:centrality_auto]{qgraph::centrality_auto}} and
\code{\link[qgraph:clustcoef_auto]{qgraph::clustcoef_auto}} functions is that
centrality and clustering values can be computed for the matrix of
interactions within a temporal network.
}
\examples{
x <- fitNetwork(ggmDat, 'M')

clustAuto(x)
centAuto(x, 'interactions')
}
\seealso{
\code{\link{centTable}, \link{clustTable}, \link{centPlot},
  \link{clustPlot}, \link{plotCentrality},
  \link[qgraph:centrality_auto]{qgraph::centrality_auto},
  \link[qgraph:clustcoef_auto]{qgraph::clustcoef_auto}}
}
