% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bs_mean.R
\name{bs_mean}
\alias{bs_mean}
\title{Nonparametric Bootstrap Confidence Interval for the Mean}
\usage{
bs_mean(x, R = 2000, conf = 0.95)
}
\arguments{
\item{x}{numeric vector of data.}

\item{R}{integer number of bootstrap replicates (default 2000).}

\item{conf}{numeric confidence level between 0 and 1 (default 0.95).}
}
\value{
A list with elements stat (mean), boot (replicates), and ci (interval).
}
\description{
Compute a bootstrap distribution for the sample mean.
}
\examples{
set.seed(42)
x <- rnorm(50, mean = 5, sd = 2)
result <- bs_mean(x, R = 500)
result$ci

}
