% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequencies.R
\name{mode_frequency_range}
\alias{mode_frequency_range}
\title{Modal frequency range}
\usage{
mode_frequency_range(x, max_unique = NULL)
}
\arguments{
\item{x}{A vector to check for its modal frequency.}

\item{max_unique}{Numeric or string. If the maximum number of unique values
in \code{x} is known, set \code{max_unique} to that number. This rules out that \code{NA}s
represent values beyond that number (see examples). Set it to \code{"known"}
instead if no values beyond those already known can occur. Default is
\code{NULL}, which assumes no maximum.}
}
\value{
Integer (length 2).
}
\description{
\code{mode_frequency_range()} determines the minimum and maximum
number of times that a vector's mode appears in the vector. The minimum
assumes that no \code{NA}s are the mode; the maximum assumes that all \code{NA}s are.
}
\details{
If there are no \code{NA}s in \code{x}, the two return values are identical.
If all \code{x} values are \code{NA}, the return values are \code{1} (no two \code{x} values
are the same) and the total number of values (all \code{x} values are the same).
}
\examples{
# The mode is `7`. It appears four or
# five times because the `NA` might
# also be a `7`:
mode_frequency_range(c(7, 7, 7, 7, 8, 8, NA))

# All of `"c"`, `"d"`, and `"e"` are the modes,
# and each of them appears twice:
mode_frequency_range(c("a", "b", "c", "c", "d", "d", "e", "e"))
}
\seealso{
\code{\link[=mode_frequency]{mode_frequency()}}, for the precise frequency (or \code{NA} if it can't
be determined).
}
