% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counts.R
\name{mode_count}
\alias{mode_count}
\title{Modal count}
\usage{
mode_count(x, na.rm = FALSE, max_unique = NULL)
}
\arguments{
\item{x}{A vector to search for its modes.}

\item{na.rm}{Boolean. Should missing values in \code{x} be removed before
computation proceeds? Default is \code{FALSE}.}

\item{max_unique}{Numeric or string. If the maximum number of unique values
in \code{x} is known, set \code{max_unique} to that number. This rules out that \code{NA}s
represent values beyond that number (see examples). Set it to \code{"known"}
instead if no values beyond those already known can occur. Default is
\code{NULL}, which assumes no maximum.}
}
\value{
Integer. Number of modes (values tied for most frequent) in \code{x}. If
the modes can't be determined because of missing values,
returns \code{NA} instead.
}
\description{
\code{mode_count()} counts the modes in a vector. Thin wrapper around
\code{\link[=mode_all]{mode_all()}}.
}
\examples{
# There are two modes, `3` and `4`:
mode_count(c(1, 2, 3, 3, 4, 4))

# Only one mode, `8`:
mode_count(c(8, 8, 9))

# Can't determine the number of modes
# here -- `9` might be another mode:
mode_count(c(8, 8, 9, NA))

# Either `1` or `2` could be a
# single mode, depending on `NA`:
mode_count(c(1, 1, 2, 2, NA))

# `1` is the most frequent value,
# no matter what `NA` stands for:
mode_count(c(1, 1, 1, 2, NA))

# Ignore `NA`s with `na.rm = TRUE`
# (there should be good reasons for this!):
mode_count(c(8, 8, 9, NA), na.rm = TRUE)
mode_count(c(1, 1, 2, 2, NA), na.rm = TRUE)
}
