% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wordcloud.R
\name{wordcloud}
\alias{wordcloud}
\title{Make a word cloud.}
\usage{
wordcloud(model_object = NULL, words = NULL, freq = NULL,
  coefficients = NULL, colors = "black", scale = c(4, 0.5),
  min_freq = 3, max_words = Inf, random_order = FALSE,
  random_color = FALSE, rot_per = 0, bg_color = "#FFFFFF")
}
\arguments{
\item{model_object}{lm. A linear model object. If this is passed, words, freq, and
coefficients can be derived and do not need to be passed.}

\item{words}{character. A vector of words to plot.}

\item{freq}{numeric. The frequency of those words.}

\item{coefficients}{numeric. If provided, colors will be assigned according to coefficients.}

\item{colors}{character. The colors to use for plotting.}

\item{scale}{numeric. The range of sizes.}

\item{min_freq}{numeric. Words with less frequency than this will not be plotted.}

\item{max_words}{numeric. Don't plot more words than this amount.}

\item{random_order}{logical. Should words be plotted in a random_order or by frequency (default FALSE)?}

\item{random_color}{logical. Allocate words a color by random? (default FALSE).}

\item{rot_per}{numeric. Amount of rotation to apply to each word, between 0 and 1. Defaults to 0 (no rotation).}

\item{bg_color}{character. The color of the background.}
}
\description{
Make a word cloud.
}
\examples{
  data(iris)
  model <- lm(Petal.Width ~ Species, iris)
  library(modelwordcloud)
  colors <- c("red", "orange", "blue")
  wordcloud(model, colors = colors)
  words_and_freqs <- rle(as.character(iris$Species))
  freqs <- words_and_freqs$lengths
  words <- words_and_freqs$values
  coefficients <- model$coefficients
  wordcloud(words = words, freq = freqs, coefficients = coefficients, colors = colors)
}
