% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mobr_boxplots.R
\name{calc_chao1}
\alias{calc_chao1}
\title{Estimation of species richness}
\usage{
calc_chao1(x)
}
\arguments{
\item{x}{a vector of species abundances or a site-by-species matrix}
}
\value{
a vector of species richness estimates
}
\description{
\code{calc_chao1} estimates the number of species at the asymptote
(\code{S_asymp}) of the species accumulation curve based on the methods
proposed in Chao (1984, 1987, 2005).
}
\details{
This function is a trimmed version of \href{https://github.com/JohnsonHsieh/iNEXT}{\code{iNext::ChaoRichness}}.
T. C. Hsieh, K. H. Ma and Anne Chao are the original authors of the
\code{iNEXT} package.
}
\examples{
data(inv_comm)
calc_chao1(inv_comm)
}
\references{
Chao, A. (1984) Nonparametric estimation of the number of classes in a
population. Scandinavian Journal of Statistics, 11, 265-270.

Chao, A. (1987) Estimating the population size for capture-recapture data with
unequal catchability. Biometrics, 43, 783-791.

Chao, A. (2005) Species estimation and applications. Pages 7907-7916 in
N. Balakrishnan, C. B. Read, and B. Vidakovic, editors. Encyclopedia of
statistical sciences. Second edition, volume 12. Wiley, New York, New York,
USA.
}
