% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mobr_boxplots.R
\name{calc_beta_div}
\alias{calc_beta_div}
\title{Calculate beta diversity from sites by species table.}
\usage{
calc_beta_div(abund_mat, index, effort = NA, C_target_gamma = NA, ...)
}
\arguments{
\item{abund_mat}{Abundance based site-by-species table. Species as
columns}

\item{index}{The calculated biodiversity indices. The options are
\itemize{
   \item \code{N} ... Number of individuals (total abundance)
   \item \code{S} ... Number of species
   \item \code{S_n} ... Rarefied or extrapolated number of species for n individuals
   \item \code{S_C} ... Estimate species richness of a given level of coverage by \code{C_target_gamma}
   \item \code{S_asymp} ... Estimated asymptotic species richness
   \item \code{f_0} ... Estimated number of undetected species 
   \item \code{pct_rare} ... The percent of rare species as defined by \code{rare_thres}
   \item \code{PIE} ... Hurlbert's PIE (Probability of Interspecific Encounter)
   \item \code{S_PIE} ... Effective number of species based on PIE
   
}
  See \emph{Details} for additional information on the
  biodiversity statistics.}

\item{effort}{The standardized number of individuals used for the 
calculation of rarefied species richness. This can a be
single integer or a vector of integers.}

\item{C_target_gamma}{When computing coverage based richness (\code{S_C}) then 
this argument can be used to specify the coverage to be used for the gamma scale
richness estimate. This defaults to \code{NA} in which case the target cover
is computed by \code{\link{calc_C_target}} (i.e., the largest allowable sample
size).}

\item{...}{other arguments to pass to \code{calc_comm_div}}
}
\description{
A wrapper for the function \code{calc_comm_div} that only returns
scales = 'beta'
}
\examples{
data(inv_comm)
beta_metrics = calc_beta_div(inv_comm, 'S_n', effort = c(5, 10))
beta_metrics
}
\seealso{
\code{\link{calc_comm_div}}
}
