% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rc_game_mgmt.R
\name{render_card_grid}
\alias{render_card_grid}
\title{Render Card Grid for Shiny App}
\usage{
render_card_grid(new_card_grid)
}
\arguments{
\item{new_card_grid}{A matrix where each entry is a list representing a card,
including information needed to render the card image.}
}
\value{
Returns a Shiny UI object that contains a rendered grid of card images.
}
\description{
This internal helper function is used to render a grid of card images in the
RepliCrisis Shiny application. It takes a matrix representing the card grid
and converts it into a Shiny UI layout with card images.
}
\details{
The function iterates over each row of the \code{new_card_grid} matrix to render
the card images using Shiny's \code{renderImage} function. It then constructs a UI
layout using \code{fluidRow} and \code{column} to display the images in a grid format
suitable for a Shiny application.

The images are sourced from the \code{mmibain} package and are assumed to be PNG
files that are formatted and named in a way that is compatible with the
\code{system.file} function used to locate them.
}
\note{
This function is an internal helper specifically designed for the RepliCrisis
Shiny application. It relies on the structure of the \code{new_card_grid} being
consistent with expected input and the \code{mmibain} package for card images.
}
\seealso{
\code{\link[shiny]{renderImage}}, \code{\link[shiny]{fluidRow}}, and \code{\link[shiny]{column}}
for details on the Shiny functions used to render images and construct the UI layout.
}
\keyword{internal}
