% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BF_for_everyone.R
\name{BF_for_everyone}
\alias{BF_for_everyone}
\title{Compute Bayes Factors for Each Participant and Summarize Results}
\usage{
BF_for_everyone(.df, .participant, formula, hypothesis)
}
\arguments{
\item{.df}{A data frame containing the data.}

\item{.participant}{A string specifying the name of the participant column in
the data frame.}

\item{formula}{A formula specifying the linear model to be fit.}

\item{hypothesis}{A string specifying the hypotheses to be tested using the
\code{bain} package.}
}
\value{
A list containing:
\describe{
\item{GPBF}{A matrix of the geometric product, evidence rate, and stability
rate for each hypothesis.}
\item{BFs}{A matrix of the Bayes Factors for each participant and hypothesis.}
\item{BF_summary}{A summary matrix of the mean, median, standard deviation,
minimum, and maximum of the Bayes Factors for each hypothesis.}
\item{N}{The number of participants.}
\item{bain_res}{A list of \code{bain} results for each participant.}
\item{Plot}{A \code{ggplot2} object visualizing the distribution of Bayes Factors
by hypothesis.}
}
}
\description{
This function splits a dataset by participants, fits linear models for each
participant, computes Bayes Factors (BFs) using the \code{bain} package, and
summarizes the results.
}
\examples{
 # Create data
 cars2 <- cars
 cars2[["parts"]] <- rep(1:10, each = 5)

 # Run analysis
 res <- BF_for_everyone(.df = cars2, .participant = "parts",
                        formula = "dist ~ speed", hypothesis = "speed > 0")

 # View GPBF results
 res$GPBF

}
\references{
Klaassen, F. (2020). Combining Evidence Over Multiple Individual Analyses. In
R. van de Schoot & M. Miočević (Eds.), Small Sample Size Solutions: A Guide for
Applied Researchers and Practitioners (1st ed., pp. 13). Routledge.
\url{doi:10.4324/9780429273872-11}
}
