% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_funcs.R
\name{i_deck}
\alias{i_deck}
\title{Add image paths to a deck of cards}
\usage{
i_deck(
  deck,
  i_path,
  cards = c("2C", "2D", "2H", "2S", "3C", "3D", "3H", "3S", "4C", "4D", "4H", "4S", "5C",
    "5D", "5H", "5S", "6C", "6D", "6H", "6S", "7C", "7D", "7H", "7S", "8C", "8D", "8H",
    "8S", "9C", "9D", "9H", "9S", "10C", "10D", "10H", "10S", "JC", "JD", "JH", "JS",
    "QC", "QD", "QH", "QS", "KC", "KD", "KH", "KS", "AC", "AD", "AH", "AS"),
  i_names = vector_playing_cards,
  i_type = "png"
)
}
\arguments{
\item{deck}{A data frame representing a deck of cards. Default is standard_deck(),
but the function is also optimized to work with shuffled_deck().}

\item{i_path}{The file path to the folder containing the card images.}

\item{cards}{A vector of card names corresponding to the images. Default includes
all cards based on a deck created with standard_deck()}

\item{i_names}{A vector of image file names corresponding to the cards.
Should be in the same order as \code{cards} the default is vector_playing_cards
which works when \code{deck} is set to standard_deck() and \code{cards} uses the default
vector.}

\item{i_type}{The file extension of the image files (e.g., "png", "jpg").}
}
\value{
A data frame that includes the original deck along with image paths for
each card. Inherits the class "ImgDeck" in addition to the original deck's classes.
}
\description{
This function takes a deck of cards and adds image paths to each card.
It produces a new deck that includes the original information along with the
image paths. The function is designed to work with various types of decks and
allows for customization of image paths.
}
\examples{
#The following example shows how to add image paths to the 'mmcards' default
#StandardDeck when the images referenced in ?vector_playing_cards are stored
#in the working directory.

 image_deck <- i_deck(deck = standard_deck(),
                      i_path = getwd())

 head(image_deck)

 #See the README for an example of how to use i_deck to incorporate images
 #into a 'shiny' application.

}
