% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.confusion.R
\name{plot.confusion}
\alias{plot.confusion}
\alias{confusion_image}
\alias{confusionImage}
\alias{confusion_barplot}
\alias{confusionBarplot}
\alias{confusion_stars}
\alias{confusionStars}
\alias{confusion_dendrogram}
\alias{confusionDendrogram}
\title{Plot a confusion matrix}
\usage{
\method{plot}{confusion}(
  x,
  y = NULL,
  type = c("image", "barplot", "stars", "dendrogram"),
  stat1 = "Recall",
  stat2 = "Precision",
  names,
  ...
)

confusion_image(
  x,
  y = NULL,
  labels = names(dimnames(x)),
  sort = "ward.D2",
  numbers = TRUE,
  digits = 0,
  mar = c(3.1, 10.1, 3.1, 3.1),
  cex = 1,
  asp = 1,
  colfun,
  ncols = 41,
  col0 = FALSE,
  grid.col = "gray",
  ...
)

confusionImage(
  x,
  y = NULL,
  labels = names(dimnames(x)),
  sort = "ward.D2",
  numbers = TRUE,
  digits = 0,
  mar = c(3.1, 10.1, 3.1, 3.1),
  cex = 1,
  asp = 1,
  colfun,
  ncols = 41,
  col0 = FALSE,
  grid.col = "gray",
  ...
)

confusion_barplot(
  x,
  y = NULL,
  col = c("PeachPuff2", "green3", "lemonChiffon2"),
  mar = c(1.1, 8.1, 4.1, 2.1),
  cex = 1,
  cex.axis = cex,
  cex.legend = cex,
  main = "F-score (precision versus recall)",
  numbers = TRUE,
  min.width = 17,
  ...
)

confusionBarplot(
  x,
  y = NULL,
  col = c("PeachPuff2", "green3", "lemonChiffon2"),
  mar = c(1.1, 8.1, 4.1, 2.1),
  cex = 1,
  cex.axis = cex,
  cex.legend = cex,
  main = "F-score (precision versus recall)",
  numbers = TRUE,
  min.width = 17,
  ...
)

confusion_stars(
  x,
  y = NULL,
  stat1 = "Recall",
  stat2 = "Precision",
  names,
  main,
  col = c("green2", "blue2", "green4", "blue4"),
  ...
)

confusionStars(
  x,
  y = NULL,
  stat1 = "Recall",
  stat2 = "Precision",
  names,
  main,
  col = c("green2", "blue2", "green4", "blue4"),
  ...
)

confusion_dendrogram(
  x,
  y = NULL,
  labels = rownames(x),
  sort = "ward.D2",
  main = "Groups clustering",
  ...
)

confusionDendrogram(
  x,
  y = NULL,
  labels = rownames(x),
  sort = "ward.D2",
  main = "Groups clustering",
  ...
)
}
\arguments{
\item{x}{a \strong{confusion} object}

\item{y}{\code{NULL} (not used), or a second \strong{confusion} object when two
different classifications are compared in the plot (\code{"stars"} type).}

\item{type}{the kind of plot to produce (\code{"image"}, the default, or
\code{"barplot"}, \code{"stars"}, \code{"dendrogram"}).}

\item{stat1}{the first metric to plot for the \code{"stars"} type (Recall by
default).}

\item{stat2}{the second metric to plot for the \code{"stars"} type (Precision by
default).}

\item{names}{names of the two classifiers to compare}

\item{...}{further arguments passed to the function. It can be all arguments
or the corresponding plot.}

\item{labels}{labels to use for the two classifications. By default, they are
the same as \code{vars}, or the one in the confusion matrix.}

\item{sort}{are rows and columns of the confusion matrix sorted so that
classes with larger confusion are closer together? Sorting is done
using a hierarchical clustering with \code{\link[=hclust]{hclust()}}. The clustering method
is \code{"ward.D2"} by default, but see the \code{\link[=hclust]{hclust()}} help for other options).
If \code{FALSE} or \code{NULL}, no sorting is done.}

\item{numbers}{are actual numbers indicated in the confusion matrix image?}

\item{digits}{the number of digits after the decimal point to print in the
confusion matrix. The default or zero leads to most compact presentation
and is suitable for frequencies, but not for relative frequencies.}

\item{mar}{graph margins.}

\item{cex}{text magnification factor.}

\item{asp}{graph aspect ratio. There is little reasons to change the default
value of 1.}

\item{colfun}{a function that calculates a series of colors, like e.g.,
\code{\link[=cm.colors]{cm.colors()}} that accepts one argument being the number of colors
to be generated.}

\item{ncols}{the number of colors to generate. It should preferably be
2 * number of levels + 1, where levels is the number of frequencies you
want to evidence in the plot. Default to 41.}

\item{col0}{should null values be colored or not (no, by default)?}

\item{grid.col}{color to use for grid lines, or \code{NULL} for not drawing grid
lines.}

\item{col}{color(s) to use for the plot.}

\item{cex.axis}{idem for axes. If \code{NULL}, the axis is not drawn.}

\item{cex.legend}{idem for legend text. If \code{NULL}, no legend is added.}

\item{main}{main title of the plot.}

\item{min.width}{minimum bar width required to add numbers.}
}
\value{
Data calculate to create the plots are returned invisibly. These
functions are mostly used for their side-effect of producing a plot.
}
\description{
Several graphical representations of \strong{confusion} objects are possible: an
image of the matrix with colored squares, a barplot comparing recall and
precision, a stars plot also comparing two metrics, possibly also comparing
two different classifiers of the same dataset, or a dendrogram grouping the
classes relative to the errors observed in the confusion matrix (classes
with more errors are pooled together more rapidly).
}
\examples{
data("Glass", package = "mlbench")
# Use a little bit more informative labels for Type
Glass$Type <- as.factor(paste("Glass", Glass$Type))

# Use learning vector quantization to classify the glass types
# (using default parameters)
summary(glass_lvq <- ml_lvq(Type ~ ., data = Glass))

# Calculate cross-validated confusion matrix and plot it in different ways
(glass_conf <- confusion(cvpredict(glass_lvq), Glass$Type))
# Raw confusion matrix: no sort and no margins
print(glass_conf, sums = FALSE, sort = FALSE)
# Plots
plot(glass_conf) # Image by default
plot(glass_conf, sort = FALSE) # No sorting
plot(glass_conf, type = "barplot")
plot(glass_conf, type = "stars")
plot(glass_conf, type = "dendrogram")

# Build another classifier and make a comparison
summary(glass_naive_bayes <- ml_naive_bayes(Type ~ ., data = Glass))
(glass_conf2 <- confusion(cvpredict(glass_naive_bayes), Glass$Type))

# Comparison plot for two classifiers
plot(glass_conf, glass_conf2)
}
