% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_deg_func.R
\name{create_deg_func}
\alias{create_deg_func}
\title{Create degradation functions for known analytical solutions}
\usage{
create_deg_func(spec, use_of_ff = c("min", "max"))
}
\arguments{
\item{spec}{List of model specifications as contained in mkinmod objects}

\item{use_of_ff}{Minimum or maximum use of formation fractions}
}
\value{
Degradation function to be attached to mkinmod objects
}
\description{
Create degradation functions for known analytical solutions
}
\examples{

SFO_SFO <- mkinmod(
  parent = mkinsub("SFO", "m1"),
  m1 = mkinsub("SFO"))
FOCUS_D <- subset(FOCUS_2006_D, value != 0) # to avoid warnings
fit_1 <- mkinfit(SFO_SFO, FOCUS_D, solution_type = "analytical", quiet = TRUE)
\dontrun{
fit_2 <- mkinfit(SFO_SFO, FOCUS_D, solution_type = "deSolve", quiet = TRUE)
if (require(rbenchmark))
  benchmark(
    analytical = mkinfit(SFO_SFO, FOCUS_D, solution_type = "analytical", quiet = TRUE),
    deSolve = mkinfit(SFO_SFO, FOCUS_D, solution_type = "deSolve", quiet = TRUE),
    replications = 2)
  DFOP_SFO <- mkinmod(
    parent = mkinsub("DFOP", "m1"),
    m1 = mkinsub("SFO"))
  benchmark(
    analytical = mkinfit(DFOP_SFO, FOCUS_D, solution_type = "analytical", quiet = TRUE),
    deSolve = mkinfit(DFOP_SFO, FOCUS_D, solution_type = "deSolve", quiet = TRUE),
    replications = 2)
}
}
