% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permanova_test.R
\name{permanova_test}
\alias{permanova_test}
\title{Perform PERMANOVA on Sets of Transmission Trees}
\usage{
permanova_test(
  ...,
  within_dist = patristic,
  between_dist = euclidean,
  test_args = list()
)
}
\arguments{
\item{...}{Two or more sets of transmission trees. Each set is a list of dataframes with columns \code{from} (infector) and \code{to} (infectee).}

\item{within_dist}{A function to compute pairwise distances within a tree. Takes a dataframe, returns a square matrix. Default is \code{\link{patristic}}.}

\item{between_dist}{A function to compute distance between two trees. Takes two matrices, returns a numeric value. Default is \code{\link{euclidean}}.}

\item{test_args}{A list of additional arguments to pass to \code{vegan::adonis2}. Default is an empty list.}
}
\value{
A \code{vegan::adonis2} object containing the test results.
}
\description{
Tests for topological differences between sets of transmission trees using PERMANOVA (via \code{vegan::adonis2}).
}
\examples{
set.seed(1)
# No difference in the sets
setA <- replicate(10, igraph::as_long_data_frame(
  make_tree(n_cases = 10, R = 2, stochastic = TRUE)
),
simplify = FALSE
)
setB <- replicate(10, igraph::as_long_data_frame(
  make_tree(n_cases = 10, R = 2, stochastic = TRUE)
),
simplify = FALSE
)
permanova_test(setA, setB)

# Difference in the sets
setC <- replicate(10, igraph::as_long_data_frame(
  make_tree(n_cases = 10, R = 4, stochastic = TRUE)
),
simplify = FALSE
)
permanova_test(setA, setB, setC)
}
