% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power-curve.R
\name{mp_power_curve}
\alias{mp_power_curve}
\title{Power curve for a single design/assumption parameter}
\usage{
mp_power_curve(
  scenario,
  vary,
  nsim = 100,
  alpha = 0.05,
  seed = NULL,
  failure_policy = c("count_as_nondetect", "exclude"),
  conf_level = 0.95
)
}
\arguments{
\item{scenario}{An \code{mp_scenario}.}

\item{vary}{Named list with a single key (e.g. \code{clusters.subject}).}

\item{nsim}{Number of simulations per grid point (default 100).}

\item{alpha}{Significance level (default 0.05).}

\item{seed}{Optional seed for reproducibility.}

\item{failure_policy}{How to treat failed fits: \code{"count_as_nondetect"} or \code{"exclude"}.}

\item{conf_level}{Confidence level for power intervals (default 0.95).}
}
\value{
An object of class \code{mp_power_curve} with components \code{vary}, \code{grid},
\code{results} (estimate, mcse, conf_low, conf_high, failure_rate, singular_rate,
n_effective, nsim, plus the varying parameter column), \code{alpha}, \code{failure_policy},
and \code{conf_level}.
}
\description{
Runs \code{\link[=mp_power]{mp_power()}} across a one-dimensional grid of values for one parameter
(e.g. cluster size) via \code{\link[=mp_sensitivity]{mp_sensitivity()}}. Results include power estimates
and per-grid-point diagnostics: failure rate, singular rate, and effective N.
}
