% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_diagnostic_functions.R
\name{predict.mixpoissonreg}
\alias{predict.mixpoissonreg}
\title{Predict Method for \code{mixpoissonreg} Objects}
\usage{
\method{predict}{mixpoissonreg}(
  object,
  newdata = NULL,
  type = c("response", "link", "precision", "variance"),
  se.fit = FALSE,
  interval = c("none", "confidence", "prediction"),
  level = 0.95,
  nsim_pred = 100,
  nsim_pred_y = 100,
  ...
)
}
\arguments{
\item{object}{object of class "mixpoissonreg" containing results from the fitted model.}

\item{newdata}{optionally, a data frame in which to look for variables with which to predict. If omitted, the fitted response values will be provided.}

\item{type}{the type of prediction. The default is the "response" type, which provided the estimated values for the means. The type "link" provides the estimates for the linear predictor. The type "precision" provides estimates for the precision parameters whereas the type "variance" provides estimates for the variances.}

\item{se.fit}{logical switch indicating if standard errors on the scale of linear predictors should be returned. If \code{TRUE}, it only returns the standard deviations of
the linear predictors when type = 'link', otherwise returns NA and a warning indicating that the type must be 'link'.  When using \code{mixpoissonreg} objects, the fit must be done with \code{x = TRUE}.}

\item{interval}{Type of interval calculation for the response variables, 'none', 'confidence' or 'prediction'. If 'confidence', the confidence intervals for the means are returned.
If 'prediction', prediction intervals for future response variables are reported. For confidence intervals, the type of the prediction must be 'response' or 'link'.
For prediction intervals the type of prediction must be 'response'. For 'confidence' intervals, when using \code{mixpoissonreg} objects, the fit must be done with \code{x = TRUE} and for
predictions intervals, the fit must be done with \code{x = TRUE} and \code{w = TRUE}.}

\item{level}{Tolerance/confidence level. The default is set to 0.95.}

\item{nsim_pred}{number of means and predictions to be generated in each step of the simulation. The default is set to 100.}

\item{nsim_pred_y}{number of response variables generated for each pair of mean and precision to compute the prediction intervals. The default is set to 100.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A vector containing the predicted values if \code{se.fit=FALSE}, a list with
elements \emph{fit} and \emph{se.fit} if \code{se.fit=TRUE}, and a matrix if \code{interval}
is set to \emph{confidence} or \emph{prediction}.
}
\description{
Function to obtain various predictions based on the fitted mixed Poisson regression models.
}
\details{
The \code{se.fit} argument only returns a non-NA vector for type = 'link', that is, on the scale of the linear predictor for the mean parameter. For the response scale,
one can obtain confidence or prediction intervals. It is important to notice that confidence intervals \emph{must not} be used for future observations as they will underestimate
the uncertainty. In this case prediction intervals should be used. Currently, we do not have closed-form expressions for the prediction interval and, therefore, they
are obtained by simulation and can be computationally-intensive.
}
\examples{

daysabs_prog <- mixpoissonreg(daysabs ~ prog, data = Attendance)
predict(daysabs_prog)

}
\seealso{
\code{\link{fitted.mixpoissonreg}}, \code{\link{summary.mixpoissonreg}}, \code{\link{plot.mixpoissonreg}}, \code{\link{autoplot.mixpoissonreg}},
\code{\link{coef.mixpoissonreg}}, \code{\link{vcov.mixpoissonreg}},
\code{\link{plot.mixpoissonreg}}
}
