% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixcure.r
\name{coef.mixcure}
\alias{coef.mixcure}
\title{Retrieve coefficients from mixture cure models}
\usage{
\method{coef}{mixcure}(object, ...)
}
\arguments{
\item{object}{a mixcure object}

\item{...}{for compatibility purpose. Not used.}
}
\value{
a list of two components:
\item{latency}{a vector of coefficients in the latency model}
\item{incidence}{a vector of coefficients in the incidence model}
}
\description{
Retrieve coefficients from mixture cure models
}
\examples{

data(leukaemia)
z1 = mixcure(Surv(time, cens) ~ transplant, ~ transplant, data = leukaemia, savedata = TRUE)
coef(z1)

}
\seealso{
mixcure
}
\author{
Yingwei Peng
}
