% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitGenotype.R
\name{splitGenotype}
\alias{splitGenotype}
\title{Split Genotype Table to Duo-Allele Table}
\usage{
splitGenotype(df,sep,dif,rowbind)
}
\arguments{
\item{df}{a dataframe of genotype data with rownames of sample ID and column names of markers.}

\item{sep}{allele separator in the imported genotype data. Note: when using the special character like "|", remember to protect it as "\\|"(default).}

\item{dif}{a symbol differentiate the one marker on each allele.}

\item{rowbind}{a logical variable. If rowbind is TRUE, the output is arranged with double rows but the same columns, and the table of the second allele is followed after the first allele table by rows with double individual IDs in the same order.\cr If rowbind is false,the output is arranged by double columns and the same rows; the column names are in the order of alphabet by pairs.}
}
\value{
a dataframe with doubled columns of import data and alleles in different columns
}
\description{
Split each column to two columns for a table of genotypes
}
\details{
The function convert a genotype data to allele data with double columns or with double rows; the rownames are sample ID in the same order but twice if the rows are doubled, and the column names are in the same order or in the order of alphabet by pairs if columns are doubled. \cr The parameter "sep" is the symbol of allele separator in the imported genotype data. \cr The parameter "dif" is the difference between the second and the first appearance for the same marker. For example, if "dif = _1", the column names of output will be "marker1" "marker1 _1","marker2","marker2 _1", if the original list of column names is "marker1","marker2".
}
\examples{
\dontrun{
df <- data.frame(SNP1=c("A|A","T|T","A|T","A|T"),
                STR1=c("12|12","13|14","13|13","14|15"))
splitGenotype(df)
}
}
