#'Genotype Data from A Selected Mix Panel
#'
#'This dataset is the phased genotypes for a mix panel with 100 variants.
#'These variants are selected from the reference haplotype data of Gymrek's lab (see Reference).
#'This is a sample with 2504 individuals.
#'
#'@docType data
#'@usage data(mixexample)
#'@format A dataframe with 2504 observations on 100 variables. This dataframe is the phased genotype files for 100 variants (including SNPs and STRs) for 2504 individuals.
#'@keywords datasets
#'@references Saini et al. (2018). A reference haplotype panel for genome-wide imputation of short tandem repeats. Nat Commun 9(1): 4397. <https://pubmed.ncbi.nlm.nih.gov/30353011/>
#'
#'@source 1000 Genomes SNP-STR Haplotype Panel <https://gymreklab.com/2018/03/05/snpstr_imputation.html>  The genotypes of panel after selection <https://github.com/ice4prince/mixIndependR/tree/main/data>
#'@examples
#'data(mixexample)

"mixexample"
