% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.missoNet.R
\name{plot.missoNet}
\alias{plot.missoNet}
\alias{plot.cv.missoNet}
\title{Plot methods for \code{missoNet} and cross-validated fits}
\usage{
\method{plot}{missoNet}(
  x,
  type = c("heatmap", "scatter"),
  detailed.axes = TRUE,
  plt.surf = TRUE,
  ...
)
}
\arguments{
\item{x}{A fitted object returned by \code{\link{missoNet}} or
\code{\link{cv.missoNet}}.}

\item{type}{Character string specifying the plot type.
One of \code{"heatmap"} (default) or \code{"scatter"}.}

\item{detailed.axes}{Logical; if \code{TRUE} (default) show dense axis labels.
If \code{FALSE}, a sparser labeling is used to avoid clutter.}

\item{plt.surf}{Logical; for \code{type = "scatter"} only, draw light surface
grid lines and highlight the minimum point. Ignored for heatmaps. Default \code{TRUE}.}

\item{...}{Additional graphical arguments forwarded to
\code{\link[ComplexHeatmap]{Heatmap}} when \code{type = "heatmap"}, or to
\code{\link[scatterplot3d]{scatterplot3d}} when \code{type = "scatter"}.}
}
\value{
\itemize{
\item For \code{type = "heatmap"}: a \code{ComplexHeatmap} \code{Heatmap}
object (invisibly drawn by \code{ComplexHeatmap}).
\item For \code{type = "scatter"}: a \code{"scatterplot3d"} object,
returned \emph{invisibly}.
}
}
\description{
Visualize either the cross-validation (CV) error surface or the
goodness-of-fit (GoF) surface over the \eqn{\lambda_B}–\eqn{\lambda_\Theta}
grid for objects returned by \code{\link{missoNet}} or \code{\link{cv.missoNet}}.
Two display types are supported:
a 2D heatmap (default) and a 3D scatter surface.
}
\details{
This S3 method detects whether \code{x} contains cross-validation results and
chooses an appropriate plotting backend:
\itemize{
\item \strong{Heatmap}: uses \code{\link[ComplexHeatmap]{Heatmap}} with a
viridis-like color ramp (via \code{\link[circlize]{colorRamp2}}). The
selected \eqn{(\lambda_B, \lambda_\Theta)} is outlined in white; 1-SE
choices (if present) are highlighted with dashed/dotted outlines.
\item \strong{Scatter}: uses \code{\link[scatterplot3d]{scatterplot3d}}
to draw the error/GoF surface on \eqn{\log_{10}} scales. When
\code{plt.surf = TRUE}, light lattice lines are added, and the minimum is
marked.
}
}
\section{What gets plotted}{

\itemize{
\item \strong{CV objects} (created by \code{\link{cv.missoNet}} or any
\code{missoNet} object that carries CV results): the color encodes the
mean CV error for each \eqn{(\lambda_B, \lambda_\Theta)} pair. The
\emph{minimum-error} solution is outlined; if 1-SE solutions were
computed, they are also marked (dashed/dotted outlines).

\item \strong{Non-CV objects} (created by \code{\link{missoNet}} without CV):
the color encodes the GoF value over the grid; the selected
\emph{minimum} (best) solution is outlined.
}
}

\section{Axes and scales}{

For heatmaps, axes are the raw \eqn{\lambda} values; rows are
\eqn{\lambda_\Theta} and columns are \eqn{\lambda_B}.
For 3D scatter plots, both \eqn{\lambda} axes are shown on the
\eqn{\log_{10}} scale for readability.
}

\section{Color mapping}{

A viridis-like palette is used. Breaks are based on distribution quantiles
of the CV error or GoF values to enhance contrast across the grid.
}

\section{Dependencies}{

Requires \pkg{ComplexHeatmap}, \pkg{circlize}, \pkg{scatterplot3d}, and \pkg{grid}.
}

\examples{
sim <- generateData(n = 150, p = 10, q = 8, rho = 0.1, missing.type = "MCAR")

\donttest{
## Fit a model without CV (plots GoF surface)
fit <- missoNet(X = sim$X, Y = sim$Z, verbose = 0)
plot(fit, type = "heatmap")                        # GoF heatmap
plot(fit, type = "scatter", plt.surf = TRUE)       # GoF 3D scatter

## Cross-validation (plots CV error surface)
cvfit <- cv.missoNet(X = sim$X, Y = sim$Z, verbose = 0)
plot(cvfit, type = "heatmap", detailed.axes = FALSE)
plot(cvfit, type = "scatter", plt.surf = FALSE)
}

}
\seealso{
\code{\link{missoNet}}, \code{\link{cv.missoNet}},
\code{\link[ComplexHeatmap]{Heatmap}}, \code{\link[scatterplot3d]{scatterplot3d}}
}
\author{
Yixiao Zeng \email{yixiao.zeng@mail.mcgill.ca}, Celia M. T. Greenwood
}
\keyword{hplot}
\keyword{models}
