% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/object.distances.R
\name{object.distances}
\alias{object.distances}
\title{Calculate distances between object vectors in a SOM}
\usage{
object.distances(kohobj, type = c("data", "ximp", "codes"))
}
\arguments{
\item{kohobj}{An object of class \code{missSOM}.}

\item{type}{Whether to calculate distances between the data objects, or the codebook vectors.}
}
\value{
An object of class \code{dist}, which can be directly fed into (e.g.) a hierarchical clustering.
}
\description{
This function calculates the distance between objects using the distance functions, 
weights and other attributes of a trained SOM. This function is used in the calculation of the U matrix in 
function \code{plot.missSOM} using the \code{type = "dist.neighbours" argument.}
}
\examples{
data(wines)

## Data with no missing values 
set.seed(7)
sommap <- imputeSOM(scale(wines), grid = somgrid(6, 4, "hexagonal"))
obj.dists <- object.distances(sommap, type = "data")
code.dists <- object.distances(sommap, type = "codes")

## Data with missing values 
X <- scale(wines)
X[1:5, 1] <- NaN
sommap <- imputeSOM(X, grid = somgrid(6, 4, "hexagonal"))
obj.dists <- object.distances(sommap, type = "ximp")
code.dists <- object.distances(sommap, type = "codes")

}
\seealso{
\code{\link{unit.distances}}, \code{\link{imputeSOM}}
}
