% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_reference_pop.R
\name{sim_reference_pop}
\alias{sim_reference_pop}
\title{Simulate Reference Population with Pigmentation Traits}
\usage{
sim_reference_pop(n = 1000, seed = 1234)
}
\arguments{
\item{n}{Integer. Number of individuals to simulate. Default: 1000.}

\item{seed}{Integer. Random seed for reproducibility. Default: 1234.}
}
\value{
A data.frame with three columns:
\itemize{
\item \code{hair_colour}: Hair color category (1-5)
\item \code{skin_colour}: Skin color category (1-5)
\item \code{eye_colour}: Eye color category (1-5)
}
Categories are numbered 1 (lightest) to 5 (darkest).
}
\description{
Generates a simulated population dataset with correlated pigmentation
characteristics (hair color, skin color, eye color). The traits are
simulated using conditional probability distributions that reflect
realistic correlations between these characteristics.
}
\details{
Hair color categories:
\enumerate{
\item Blonde/Light
\item Light brown
\item Medium brown
\item Dark brown
\item Black
}

The simulation uses conditional probability distributions where:
\itemize{
\item Hair color is sampled first from population frequencies
\item Skin color is sampled conditional on hair color
\item Eye color is sampled conditional on both hair and skin color
}

This captures realistic correlations (e.g., darker hair tends to
co-occur with darker skin and eyes).
}
\examples{
# Simulate a population of 500 individuals
pop_data <- sim_reference_pop(n = 500, seed = 123)
head(pop_data)

# Check trait distributions
table(pop_data$hair_colour)
table(pop_data$skin_colour)
table(pop_data$eye_colour)

# Use for LR calculations
conditioned <- compute_conditioned_prop(pop_data, h = 1, s = 1, y = 1,
                                        eh = 0.01, es = 0.01, ey = 0.01)
unconditioned <- compute_reference_prop(pop_data)
}
\references{
Marsico FL, et al. (2023). "Likelihood ratios for non-genetic evidence
in missing person cases." \emph{Forensic Science International: Genetics},
66, 102891. \doi{10.1016/j.fsigen.2023.102891}
}
\seealso{
\code{\link{compute_conditioned_prop}} for computing proportions,
\code{\link{compute_reference_prop}} for reference frequencies,
\code{\link{lr_pigmentation}} for pigmentation LR calculations.
}
