% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simRef.R
\name{simRef}
\alias{simRef}
\title{Generate Reference Properties for a Hypothetical Population}
\usage{
simRef(n = 1000, seed = 1234)
}
\arguments{
\item{n}{The number of individuals in the simulated population.}

\item{seed}{Selected seed for simulations.}
}
\value{
A \code{data.frame} with three columns: hair_colour, skin_colour, and eye_colour,
each representing the respective characteristics of each individual in the sample population.
The hair color is simulated based on predefined probabilities, and skin and eye colors
are generated conditionally based on the hair color.
}
\description{
This function simulates a dataset representing physical characteristics
(hair color, skin color, eye color) of a hypothetical population,
based on conditional probability distributions. The size of the simulated population
can be adjusted by the user.
}
\examples{
simRef(1000) # Generates a data frame with 1000 entries based on the defined distributions.
}
