% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mipplot_point.R
\name{mipplot_point}
\alias{mipplot_point}
\title{Point plot from IAMC data}
\usage{
mipplot_point(
  D,
  region = levels(D$region),
  variable = levels(D$variable),
  target_year = levels(as.factor(D$period)),
  colorby = "model",
  shapeby = "model",
  xby = "scenario",
  facetby = NULL,
  facet_x = NULL,
  facet_y = NULL,
  fontsize = 20,
  PRINT_OUT = FALSE,
  DEBUG = TRUE
)
}
\arguments{
\item{D}{A dataframe of IAMC data in tibble format to produce plots.}

\item{region}{A list of regions.}

\item{variable}{A list of variables.}

\item{target_year}{A list of target years.}

\item{colorby}{An axis for color setting.}

\item{shapeby}{An axis for shape setting.}

\item{xby}{An axis for x locating setting.}

\item{facetby}{facetby.}

\item{facet_x}{facet_x.}

\item{facet_y}{facet_y.}

\item{fontsize}{font size.}

\item{PRINT_OUT}{set TRUE to generate PDF image.}

\item{DEBUG}{set TRUE to show debug messages.}
}
\value{
A list of point plots.
}
\description{
The function arguments include the input dataframe,
             labels for the plot/axes/legend, and faceting dimensions
}
\examples{
\donttest{
library(dplyr)
data_subset <- ar5_db_sample_data \%>\%
filter(variable == "Emissions|CO2|Land Use") \%>\%
filter(model \%in\% c("AIM-Enduse 12.1", "GCAM 3.0", "IMAGE 2.4")) \%>\%
filter(period == 2100) \%>\% filter(region == "OECD90")
mipplot_point(data_subset)
}
}
